package org.maachang.session.server ;

import org.maachang.connector.ConnectorCallback;
import org.maachang.connector.ConnectorSession;
import org.maachang.session.engine.PersistenceDefine;
import org.maachang.session.engine.PersistenceEngine;
import org.maachang.session.server.protocol.IOServerProtocol;
import org.maachang.session.server.protocol.ServerProtocol;


/**
 * PersistenceSessionサーバコールバック.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
class PSessionCallback implements ConnectorCallback {
    
    /**
     * セッションエンジン.
     */
    private PersistenceEngine pse = null ;
    
    /**
     * コンストラクタ.
     */
    private PSessionCallback() {
        
    }
    
    /**
     * コンストラクタ.
     * @parma pse セッションエンジンを設定します.
     * @exception Exception 例外.
     */
    public PSessionCallback( PersistenceEngine pse )
        throws Exception {
        if( pse == null || pse.isUse() == false ) {
            throw new IllegalArgumentException( "引数は不正です" ) ;
        }
        this.pse = pse ;
    }
    
    /**
     * 受信コールバック機能.
     * @param session 対象のセッション情報を設定します.
     * @param receive 受信されたバイナリを設定します.
     * @exception Exception 例外.
     */
    public void execution( ConnectorSession session,byte[] receive )
        throws Exception {
        // 受信結果を解析／実行.
        ServerProtocol sv = IOServerProtocol.execution( pse,receive,PersistenceDefine.PROTOCOL_OFFSET ) ;
        // 受信結果を送信.
        session.send( sv.getResult() ) ;
    }
    
}
