package org.maachang.session.server.protocol ;

/**
 * サーバプロトコル.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public abstract class ServerProtocol {
    
    /**
     * サーバマスク.
     */
    public static final int TYPE_MASK = 0x000000ff ;
    
    /**
     * サーバプロトコルタイプ : 新しいセッションIDを要求.
     */
    public static final int TYPE_CREATE_SESSION = 0x00000001 ;
    
    /**
     * サーバプロトコルタイプ : セッションID問合せ.
     */
    public static final int TYPE_USE_SESSION_ID = 0x00000002 ;
    
    /**
     * サーバプロトコルタイプ : 指定セッション削除.
     */
    public static final int TYPE_DELETE_SESSION_ID = 0x00000003 ;
    
    /**
     * サーバプロトコルタイプ : セッション更新時間取得.
     */
    public static final int TYPE_UPDATE_SESSION_ID = 0x00000004 ;
    
    /**
     * サーバプロトコルタイプ : 指定セッション非存在時に新規セッション作成.
     */
    public static final int TYPE_USE_TO_SESSOIN_ID = 0x00000005 ;
    
    /**
     * サーバプロトコルタイプ : セッション削除時間取得.
     */
    public static final int TYPE_DELETE_SESSION_TIME = 0x00000006 ;
    
    /**
     * サーバプロトコルタイプ : Key要素追加.
     */
    public static final int TYPE_PUT_VALUE = 0x00000010 ;
    
    /**
     * サーバプロトコルタイプ : Key要素削除.
     */
    public static final int TYPE_REMOVE_VALUE = 0x00000011 ;
    
    /**
     * サーバプロトコルタイプ : Key要素取得.
     */
    public static final int TYPE_GET_VALUE = 0x00000012 ;
    
    /**
     * サーバプロトコルタイプ : エラープロトコル.
     */
    public static final int TYPE_ERROR = 0x000000ff ;
    
    /**
     * 結果情報.
     */
    protected byte[] result = null ;
    
    /**
     * サーバプロトコルタイプを取得.
     * @return int サーバプロトコルタイプが返されます.
     */
    public abstract int getProtocolType() ;
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @exception Exception 例外.
     */
    public abstract void setResult( Object value )
        throws Exception ;
    
    /**
     * 処理結果の内容を取得.
     * @return byte[] 処理結果の内容が返されます.
     */
    public byte[] getResult() {
        return result ;
    }
}

