package org.maachang.session.server.protocol ;

import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

/**
 * セッションID更新時間要求.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class SvDeleteSessionTimeProtocol extends ServerProtocol {
    
    /**
     * コンストラクタ.
     */
    public SvDeleteSessionTimeProtocol() {
    }
    
    /**
     * サーバプロトコルタイプを取得.
     * @return int サーバプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_DELETE_SESSION_TIME ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @exception Exception 例外.
     */
    public void setResult( Object value ) throws Exception {
        ArrayBinary b = new ArrayBinary( 16 ) ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        b.write( ConvertParam.convertLong( ( ( Long )value ).longValue() ) ) ;
        this.result = b.getBinary() ;
    }
}

