package org.maachang.session.server.protocol ;

import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

/**
 * セッションIDに対して要素を取得.
 * 
 * @version 2008/05/25
 * @author masahito suzuki
 * @since PersistenceSession 1.00
 */
public class SvGetSessionKeyProtocol extends ServerProtocol {
    
    /**
     * セッションID.
     */
    private String sessionId = null ;
    
    /**
     * 要素キー名.
     */
    private String key = null ;
    
    /**
     * コンストラクタ.
     */
    public SvGetSessionKeyProtocol( byte[] bin,int p )
        throws Exception {
        int len = ConvertParam.convertInt( p,bin ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( bin,p,b,0,len ) ;
            this.sessionId = new String( b,"UTF8" ) ;
            p += len ;
        }
        len = ConvertParam.convertInt( p,bin ) ;
        p += 4 ;
        if( len > 0 ) {
            byte[] b = new byte[ len ] ;
            System.arraycopy( bin,p,b,0,len ) ;
            this.key = new String( b,"UTF8" ) ;
            p += len ;
        }
    }
    
    /**
     * サーバプロトコルタイプを取得.
     * @return int サーバプロトコルタイプが返されます.
     */
    public int getProtocolType() {
        return TYPE_GET_VALUE ;
    }
    
    /**
     * セッションIDを取得.
     * @return String セッションIDが返されます.
     */
    public String getSessionId() {
        return sessionId ;
    }
    
    /**
     * 要素キー名を取得.
     * @return String 要素キー名が返されます.
     */
    public String getKey() {
        return key ;
    }
    
    /**
     * 処理結果の内容を設定.
     * @param value 処理結果の内容を設定します.
     * @exception Exception 例外.
     */
    public void setResult( Object value ) throws Exception {
        byte[] valBin = ( byte[] )value ;
        ArrayBinary b = new ArrayBinary() ;
        b.write( ConvertParam.convertInt( getProtocolType() ) ) ;
        int len = 0 ;
        if( value != null ) {
            len = valBin.length ;
        }
        b.write( ConvertParam.convertInt( len ) ) ;
        if( len > 0 ) {
            b.write( valBin ) ;
        }
        this.result = b.getBinary() ;
    }
}

