/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.session.engine;

import java.util.Enumeration;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dbm.MDbmOp;
import org.maachang.session.engine.CacheValue;
import org.maachang.session.engine.SessionCache;
import org.maachang.session.engine.SessionIdLock;
import org.maachang.util.thread.LoopThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MDbmSessionMonThread
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(MDbmSessionMonThread.class);
    private long timeout = -1L;
    private MDbmOp mdbm = null;
    private Map<String, CacheValue> cache = null;
    private SessionIdLock idLock = null;

    private MDbmSessionMonThread() {
    }

    public MDbmSessionMonThread(MDbmOp mdbm, Map<String, CacheValue> cache, SessionIdLock idLock, long timeout) throws Exception {
        this.mdbm = mdbm;
        this.cache = cache;
        this.timeout = timeout;
        this.idLock = idLock;
        this.startThread();
    }

    protected void clear() {
        this.mdbm = null;
        this.cache = null;
    }

    protected void toException(Exception e) {
        LOG.warn((Object)"## sessionMonitor-error", (Throwable)e);
    }

    protected boolean execution() throws Exception {
        if (this.mdbm.size() <= 0) {
            Thread.sleep(1000L);
        } else {
            Enumeration keys = this.mdbm.elements();
            while (keys.hasMoreElements()) {
                Thread.sleep(250L);
                byte[] keyBin = (byte[])keys.nextElement();
                if (keyBin == null) continue;
                String key = new String(keyBin, "UTF8");
                keyBin = null;
                if (!key.startsWith("@session@base:")) continue;
                String sessionId = SessionCache.toSessionId(key);
                this.idLock.lock(sessionId);
                try {
                    long time;
                    if (!this.mdbm.containsKey(key) || (time = SessionCache.getSessionTime(this.mdbm, key)) > -1L && time + this.timeout > System.currentTimeMillis()) continue;
                    SessionCache.removeSession(this.mdbm, this.cache, sessionId);
                    LOG.info((Object)("## \u6c38\u7d9a\u5316\u30bb\u30c3\u30b7\u30e7\u30f3[" + sessionId + "]\u3092\u524a\u9664\u3057\u307e\u3057\u305f"));
                }
                finally {
                    this.idLock.unlock(sessionId);
                }
            }
            Thread.sleep(250L);
        }
        return false;
    }
}

