/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.MDbmImpl;
import org.maachang.dbm.MDbmOp;
import org.maachang.dbm.MDbmOpImpl;
import org.maachang.dbm.MDbmTransaction;
import org.maachang.dbm.engine.MDbmEngineUtil;
import org.maachang.dbm.service.MDbmServerService;
import org.maachang.util.FileUtil;

public class MDbmManager {
    public static final int MIN = 0;
    public static final int MID = 1;
    public static final int MAX = 2;
    private MDbmImpl impl = null;
    private MDbmServerService server = null;
    private int mode = 1;
    private static final MDbmManager SNGL = new MDbmManager();
    private static final String OPT = "mdbm-opt";

    private MDbmManager() {
    }

    public static final MDbmManager getInstance() {
        return SNGL;
    }

    public synchronized int getMode() {
        return this.mode;
    }

    public synchronized void open(String directory) throws Exception {
        if (this.impl == null) {
            this.readMDbmOpt();
            if (MDbmEngineUtil.isMDbmVersion(directory)) {
                throw new IOException("MDBM\u306e\u69cb\u6210\u30d0\u30fc\u30b8\u30e7\u30f3\u304c\u4e00\u81f4\u3057\u307e\u305b\u3093");
            }
            this.impl = new MDbmImpl(directory);
        }
    }

    public synchronized void close() {
        if (this.server != null) {
            this.server.destroy();
        }
        this.server = null;
        if (this.impl != null) {
            this.impl.destroy();
        }
        this.impl = null;
    }

    public synchronized void flush() throws Exception {
        if (this.impl != null) {
            this.impl.flush();
        }
    }

    public synchronized MDbm getMDbm() {
        return this.getMDbm(false);
    }

    public synchronized MDbm getMDbm(boolean mode) {
        if (this.impl != null) {
            if (mode) {
                return new MDbmTransaction(this.impl);
            }
            return this.impl;
        }
        return null;
    }

    public synchronized MDbm getTransaction(MDbm mdbm) {
        if (mdbm != null) {
            return new MDbmTransaction(this.impl);
        }
        return null;
    }

    public synchronized MDbmOp getMDbmOp(MDbm mdbm) {
        if (mdbm == null || !mdbm.isUse()) {
            throw new IllegalArgumentException("\u6307\u5b9aMDBM\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return new MDbmOpImpl(mdbm);
    }

    public synchronized MDbmOp getMDbmOp() {
        return this.getMDbmOp(false);
    }

    public synchronized MDbmOp getMDbmOp(boolean mode) {
        if (this.impl != null) {
            if (mode) {
                return new MDbmOpImpl(new MDbmTransaction(this.impl));
            }
            return new MDbmOpImpl(this.impl);
        }
        return null;
    }

    public synchronized boolean isClose() {
        return this.impl == null;
    }

    public synchronized String getDirectory() {
        if (this.impl != null) {
            return this.impl.getDirectory();
        }
        return null;
    }

    public synchronized int size() {
        if (this.impl != null) {
            return this.impl.size();
        }
        return -1;
    }

    public synchronized int sectorFile() {
        if (this.impl != null) {
            return this.impl.sectorFile();
        }
        return -1;
    }

    public synchronized int useSector() {
        if (this.impl != null) {
            return this.impl.useSector();
        }
        return -1;
    }

    public synchronized int maxSector() {
        if (this.impl != null) {
            return this.impl.maxSector();
        }
        return -1;
    }

    public synchronized long freeSpace() {
        if (this.impl != null) {
            return this.impl.freeSpace();
        }
        return -1L;
    }

    public synchronized void setServer(MDbmServerService server) {
        this.server = server;
    }

    public synchronized MDbmServerService getServer() {
        return this.server;
    }

    private void setMode(int mode) throws IOException {
        if (this.impl != null) {
            throw new IOException("\u8d77\u52d5\u5f8c\u306b\u8a2d\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        switch (mode) {
            case 0: {
                this.mode = mode;
                if (System.getProperty("mdbm.hash") == null) {
                    System.setProperty("mdbm.hash", String.valueOf(16));
                }
                if (System.getProperty("mdbm.key") == null) {
                    System.setProperty("mdbm.key", String.valueOf(64));
                }
                if (System.getProperty("mdbm.sector") == null) {
                    System.setProperty("mdbm.sector", String.valueOf(512));
                }
                if (System.getProperty("mdbm.maxLength") != null) break;
                System.setProperty("mdbm.maxLength", String.valueOf(100000));
                break;
            }
            case 1: {
                this.mode = mode;
                if (System.getProperty("mdbm.hash") == null) {
                    System.setProperty("mdbm.hash", String.valueOf(20));
                }
                if (System.getProperty("mdbm.key") == null) {
                    System.setProperty("mdbm.key", String.valueOf(256));
                }
                if (System.getProperty("mdbm.sector") == null) {
                    System.setProperty("mdbm.sector", String.valueOf(512));
                }
                if (System.getProperty("mdbm.maxLength") != null) break;
                System.setProperty("mdbm.maxLength", String.valueOf(15000000));
                break;
            }
            case 2: {
                this.mode = mode;
                if (System.getProperty("mdbm.hash") == null) {
                    System.setProperty("mdbm.hash", String.valueOf(26));
                }
                if (System.getProperty("mdbm.key") == null) {
                    System.setProperty("mdbm.key", String.valueOf(1024));
                }
                if (System.getProperty("mdbm.sector") == null) {
                    System.setProperty("mdbm.sector", String.valueOf(8192));
                }
                if (System.getProperty("mdbm.maxLength") != null) break;
                System.setProperty("mdbm.maxLength", String.valueOf(50000000));
            }
        }
    }

    private boolean readMDbmOpt() throws Exception {
        if (this.impl != null) {
            throw new IOException("\u8d77\u52d5\u5f8c\u306b\u8a2d\u5b9a\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093");
        }
        if (!FileUtil.isFileExists((String)"./conf/mdbm.conf")) {
            return false;
        }
        BufferedReader br = null;
        br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("./conf/mdbm.conf"), "UTF8"));
        Config conf = new Config();
        ReadIni.analisys((Config)conf, (BufferedReader)br);
        br.close();
        br = null;
        String s = conf.get(OPT, "mode", 0);
        if (!conf.isSection(OPT)) {
            return false;
        }
        int c = conf.getInt(OPT, "mdbm.hash", 0);
        if (c >= 0) {
            System.setProperty("mdbm.hash", String.valueOf(c));
        }
        if ((c = conf.getInt(OPT, "mdbm.key", 0)) >= 0) {
            System.setProperty("mdbm.key", String.valueOf(c));
        }
        if ((c = conf.getInt(OPT, "mdbm.sector", 0)) >= 0) {
            System.setProperty("mdbm.sector", String.valueOf(c));
        }
        if ((c = conf.getInt(OPT, "mdbm.maxLength", 0)) >= 0) {
            System.setProperty("mdbm.maxLength", String.valueOf(c));
        }
        int mode = 1;
        if (s != null && (s = s.trim()).length() > 0) {
            if ("min".equals(s = s.toLowerCase())) {
                mode = 0;
            } else if ("mid".equals(s)) {
                mode = 1;
            } else if ("max".equals(s)) {
                mode = 2;
            }
        }
        this.setMode(mode);
        return true;
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

