/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service;

import java.util.Iterator;
import java.util.Map;
import org.maachang.dbm.MDbm;
import org.maachang.dbm.service.KeySessionChild;
import org.maachang.util.thread.LoopThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeySessionMonThread
extends LoopThread {
    private long timeout = -1L;
    private Map<Long, KeySessionChild> map = null;

    private KeySessionMonThread() {
    }

    public KeySessionMonThread(Map<Long, KeySessionChild> map, long timeout) throws Exception {
        this.map = map;
        this.timeout = timeout;
        this.startThread();
    }

    protected void clear() {
        this.map = null;
    }

    protected boolean execution() throws Exception {
        if (this.map.size() <= 0) {
            Thread.sleep(500L);
        } else {
            Iterator<Long> keys = this.map.keySet().iterator();
            while (keys.hasNext()) {
                Thread.sleep(50L);
                Long key = keys.next();
                KeySessionChild ch = this.map.get(key);
                if (ch.getLastUpdate() + this.timeout > System.currentTimeMillis()) continue;
                MDbm mdbm = ch.getMDbm();
                if (mdbm != null) {
                    try {
                        mdbm.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        mdbm.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                keys.remove();
            }
        }
        return false;
    }
}

