/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.auth;

import java.util.HashMap;
import java.util.HashSet;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdVersionDef;
import org.maachang.comet.httpd.engine.auth.HttpdAuthElement;
import org.maachang.comet.httpd.engine.auth.HttpdAuthManager;
import org.maachang.comet.httpd.engine.auth.HttpdAuthUsers;
import org.maachang.util.Digest;
import org.maachang.util.RandomUtil;

public class HttpdAuthDigest {
    public static final String AUTH_TYPE_BY_DIGEST = "digest";
    private static final String DIGEST = "MD5";
    public static final int MAX_RANDOM = 0xFFFFFFF;

    private HttpdAuthDigest() {
    }

    public static final String getSendAuth(HttpdAuthElement element) {
        String digest = HttpdAuthDigest.getDigestByMd5();
        if (digest == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Digest").append(" realm=").append("\"").append(element.getRealm()).append("\"").append(", ").append("nonce=").append("\"").append(digest).append("\"").append(", ").append("algorithm=").append(DIGEST).append(", ").append("qop=").append("\"").append("auth").append("\"");
        return buf.toString();
    }

    public static final boolean isAuth(HttpdRequest request, HttpdAuthElement element, HttpdAuthUsers users, HttpdHeaders headerParams) {
        HashMap<String, String> params = null;
        params = headerParams.getHeaders("Authorization");
        if (params != null) {
            try {
                if (params.get("Digest") == null) {
                    return false;
                }
                String username = params.get("username");
                String realm = params.get("realm");
                String qop = params.get("qop");
                String algorithm = params.get("algorithm");
                String url = params.get("uri");
                String nonce = params.get("nonce");
                String nc = params.get("nc");
                String cnonce = params.get("cnonce");
                String response = params.get("response");
                HashSet<String> userset = element.getUsers();
                if (username == null || realm == null || qop == null || algorithm == null || url == null || nonce == null || nc == null || cnonce == null || response == null) {
                    return false;
                }
                if (!algorithm.equals(DIGEST)) {
                    return false;
                }
                if (users == null || userset == null || !users.isUser(username)) {
                    return false;
                }
                if (userset.size() > 0 && !userset.contains(username)) {
                    return false;
                }
                userset = null;
                String[] passwd = users.getPassword(username);
                if (passwd != null) {
                    int clen = passwd.length;
                    int i = 0;
                    while (i < clen) {
                        if (passwd[i] == null || passwd[i].length() <= 0) {
                            passwd[i] = "";
                        }
                        StringBuilder buf = new StringBuilder();
                        buf.append(username);
                        buf.append(":").append(realm).append(":").append(passwd[i]);
                        byte[] bin = buf.toString().getBytes("UTF8");
                        String key1 = Digest.convert((String)DIGEST, (byte[])bin, (int)0, (int)bin.length);
                        buf = new StringBuilder();
                        buf.append(request.getMethod()).append(":").append(url);
                        bin = buf.toString().getBytes("UTF8");
                        String key2 = Digest.convert((String)DIGEST, (byte[])bin, (int)0, (int)bin.length);
                        bin = null;
                        buf = new StringBuilder();
                        buf.append(key1).append(":").append(nonce).append(":").append(nc).append(":").append(cnonce).append(":").append(qop).append(":").append(key2);
                        bin = buf.toString().getBytes("UTF8");
                        String check = Digest.convert((String)DIGEST, (byte[])bin, (int)0, (int)bin.length);
                        buf = null;
                        key1 = null;
                        key2 = null;
                        if (response.equals(check)) {
                            HttpdAuthManager.setSuccessAuth(request, username, passwd[i]);
                            return true;
                        }
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static final String getDigestByMd5() {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append("@").append(HttpdVersionDef.getName()).append("$").append(HttpdVersionDef.getVersion()).append("$").append(HttpdVersionDef.getDate()).append("t").append(System.currentTimeMillis()).append("r").append(RandomUtil.random((int)0xFFFFFFF));
            byte[] bin = buf.toString().getBytes("UTF8");
            return Digest.convert((String)DIGEST, (byte[])bin, (int)0, (int)bin.length);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

