/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.net.ssl.SSLSocket;
import org.maachang.comet.httpd.HttpdHeaders;
import org.maachang.comet.httpd.HttpdParams;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.engine.HttpdCookie;
import org.maachang.comet.httpd.engine.session.HttpdSession;
import org.maachang.comet.httpd.engine.session.HttpdSessionManager;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.manager.GlobalManager;

public class HttpdRequestImpl
implements HttpdRequest {
    private String method = null;
    private String httpVersion = null;
    private String urlPath = null;
    private HttpdParams query = null;
    private HttpdHeaders header = null;
    private HttpdSession session = null;
    private byte[] httpBody = null;
    private ConnectionInfo conn = null;
    private boolean gzipFlag = false;
    private boolean cookieFlag = false;
    private boolean sslFlag = false;
    private static final String[] SESSION_LIST = new String[]{".ms", ".mhtml", ".js", ".html", ".htm"};

    public HttpdRequestImpl() {
        this.query = new HttpdParams();
        this.header = new HttpdHeaders();
        this.sslFlag = false;
    }

    public HttpdRequestImpl(String method, String version, String url, HttpdHeaders header, HttpdParams query) throws Exception {
        if (method == null || (method = method.trim()).length() <= 0 || version == null || (version = version.trim()).length() <= 0 || url == null || (url = url.trim()).length() <= 0 || header == null || header.size() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.method = method;
        this.httpVersion = version;
        this.urlPath = url;
        this.header = header;
        this.query = query == null ? new HttpdParams() : query;
        this.sslFlag = false;
    }

    protected void finalize() throws Exception {
        this.method = null;
        this.httpVersion = null;
        this.urlPath = null;
        this.query = null;
        this.header = null;
        this.session = null;
        this.httpBody = null;
        this.conn = null;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setHttpVersion(String httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getVersion() {
        return this.httpVersion.substring("HTTP/".length());
    }

    public void setUrlPath(String urlPath) {
        this.urlPath = urlPath;
    }

    public String getUrlPath() {
        return this.urlPath;
    }

    public HttpdParams getQuery() {
        return this.query;
    }

    public HttpdHeaders getHeader() {
        return this.header;
    }

    public HttpdSession getSession() throws Exception {
        if (this.session == null) {
            HttpdSessionManager sessionManager = (HttpdSessionManager)GlobalManager.getValue((String)"SESSION_MANAGER");
            String id = null;
            String cookie = HttpdCookie.getCookie(this);
            if (cookie != null) {
                HashMap<String, String> ana = HttpdCookie.analysisCookie(cookie);
                id = ana.get("maachang-session");
                if (id != null && id.length() == 48) {
                    this.session = sessionManager.getSession(id);
                }
                this.cookieFlag = true;
            }
            if (this.session == null) {
                if (HttpdRequestImpl.isSessionId(this.urlPath)) {
                    id = this.query.getParam("_maachang-session");
                    this.session = id != null && id.length() == 48 && sessionManager.getSession(id) != null ? sessionManager.getSession(id) : sessionManager.getNewSession();
                    this.query.setParam("_maachang-session", this.session.getSessionId());
                }
                this.cookieFlag = false;
            }
        }
        return this.session;
    }

    public InputStream getBody() {
        if (this.httpBody == null) {
            return null;
        }
        return new ByteArrayInputStream(this.httpBody);
    }

    public byte[] getBodyByBinary() {
        if (this.httpBody == null) {
            return null;
        }
        return this.httpBody;
    }

    public void setBody(byte[] body) {
        this.httpBody = (byte[])(body == null || body.length <= 0 ? null : body);
    }

    public void setConnectionInfo(ConnectionInfo conn) {
        this.sslFlag = conn.getElement().getChannel().socket() instanceof SSLSocket;
        this.conn = conn;
    }

    public ConnectionInfo getConnectionInfo() {
        return this.conn;
    }

    public void setKeepAliveTimeout(int timeout) {
        if ((long)timeout > 0L) {
            this.conn.setTimeout(timeout);
        }
    }

    public long getKeepAliveTimeout() {
        if (this.conn == null) {
            return -1L;
        }
        return this.conn.getTimeout();
    }

    public int getKeepAliveCount() {
        if (this.conn == null) {
            return -1;
        }
        return this.conn.getCount();
    }

    public void setGzip(boolean flag) {
        this.gzipFlag = flag;
    }

    public boolean isGzip() {
        return this.gzipFlag;
    }

    public boolean isCookie() {
        return this.cookieFlag;
    }

    public boolean isSsl() {
        return this.sslFlag;
    }

    public boolean isUse() {
        return this.conn != null && this.conn.isUse();
    }

    public String toIpPort() {
        return this.conn.getInetAddress().getHostAddress() + "/" + this.conn.getPort();
    }

    public static final boolean isSessionId(String path) {
        int x = path.lastIndexOf("/");
        if (x >= 0) {
            path = path.substring(x);
        }
        if (path.lastIndexOf(".") <= -1) {
            return true;
        }
        int len = SESSION_LIST.length;
        path = path.trim().toLowerCase();
        int i = 0;
        while (i < len) {
            if (path.endsWith(SESSION_LIST[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

