/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.NetServerImpl;
import org.maachang.comet.net.NetSslServerImpl;
import org.maachang.comet.net.nio.HttpReceiveCallback;
import org.maachang.comet.net.nio.NioService;
import org.maachang.comet.net.ssl.SslOption;
import org.maachang.comet.net.ssl.SslServerFactory;

public class NetService {
    private static final Log LOG = LogFactory.getLog(NetService.class);
    private SslServerFactory sslFactory = null;
    private NetServerImpl http = null;
    private NetSslServerImpl ssl = null;
    private NioService nioService = null;

    protected void finalize() throws Exception {
        this.close();
    }

    public void open(HttpReceiveCallback call, SslOption opt, int maxConnect, int length, int port) throws Exception {
        this.open(call, opt, maxConnect, length, null, port);
    }

    public void open(HttpReceiveCallback call, SslOption opt, int maxConnect, int length, InetAddress addr, int port) throws Exception {
        if (call == null) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        try {
            int sslCon = -1;
            if (opt != null) {
                sslCon = maxConnect / 4;
                if (sslCon <= 0) {
                    sslCon = 1;
                }
                maxConnect -= sslCon;
            }
            this.http = new NetServerImpl(addr, port, maxConnect);
            if (sslCon > 0) {
                this.sslFactory = new SslServerFactory(opt);
                this.ssl = new NetSslServerImpl(this.sslFactory, opt.getSslAddress(), opt.getSslPort(), sslCon);
            } else {
                this.sslFactory = null;
                this.ssl = null;
            }
            this.nioService = new NioService();
            this.nioService.open(call, this.http, this.ssl, length);
        }
        catch (Exception e) {
            LOG.error((Object)"## error", (Throwable)e);
            this.close();
            throw e;
        }
    }

    public void close() {
        if (this.nioService != null) {
            this.nioService.close();
        }
        if (this.ssl != null) {
            this.ssl.destroy();
        }
        if (this.http != null) {
            this.http.destroy();
        }
        this.sslFactory = null;
        this.nioService = null;
        this.ssl = null;
        this.http = null;
    }

    public SslServerFactory getSslServerFactory() {
        return this.sslFactory;
    }
}

