/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.maachang.comet.net.HttpServer;
import org.maachang.comet.net.ssl.SslServerFactory;

class NetSslServerImpl
implements HttpServer {
    private static final int DEFAULT_PORT = 3443;
    protected static final int MIN_LENGTH = 1;
    protected static final int MAX_LENGTH = 5000;
    private ServerSocket serverSocket = null;

    private NetSslServerImpl() {
    }

    public NetSslServerImpl(SslServerFactory factory, int port, int backlog) throws Exception {
        this(factory, null, port, backlog);
    }

    public NetSslServerImpl(SslServerFactory factory, InetAddress addr, int port, int backlog) throws Exception {
        if (factory == null) {
            throw new IllegalArgumentException("SslServerFactory\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (backlog <= 1) {
            backlog = 1;
        } else if (backlog > 5000) {
            backlog = 5000;
        }
        if (port <= 0 || port > 65535) {
            port = 3443;
        }
        ServerSocket server = factory.serverSocket();
        server.getChannel().configureBlocking(false);
        server.setReuseAddress(true);
        if (addr == null) {
            server.bind(new InetSocketAddress(port), backlog);
        } else {
            server.bind(new InetSocketAddress(addr, port), backlog);
        }
        this.serverSocket = server;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverSocket = null;
    }

    public ServerSocket serverSocket() {
        if (this.isClosed()) {
            return null;
        }
        return this.serverSocket;
    }

    public boolean isClosed() {
        boolean ret = false;
        try {
            if (this.serverSocket == null || !this.serverSocket.isBound() || this.serverSocket.isClosed()) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }
}

