/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.maachang.comet.net.nio.NioReceiveServerArray;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.thread.LoopThread;

class NioBaseServer
extends LoopThread {
    private static final int RECV_THREAD_SIZE = 5;
    private ServerSocket serverSocket = null;
    private ServerSocketChannel server = null;
    private Selector selector = null;
    private NioReceiveServerArray recvServer = null;
    private static final int BUFFER = 131072;
    private static final int LINGER = 5;

    private NioBaseServer() {
    }

    public NioBaseServer(ServerSocket serverSocket, ReceiveLinkQueue queue) throws Exception {
        if (serverSocket == null || queue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.serverSocket = serverSocket;
        this.serverSocket.setReuseAddress(true);
        this.server = serverSocket.getChannel();
        this.selector = Selector.open();
        this.server.register(this.selector, 16);
        this.recvServer = new NioReceiveServerArray(queue, 5);
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        if (this.recvServer != null) {
            this.destroy();
        }
        this.recvServer = null;
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        SelectionKey key = itr.next();
                        SelectableChannel c = key.channel();
                        c.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverSocket = null;
        this.server = null;
    }

    protected boolean execution() throws Exception {
        while (this.selector.select() > 0) {
            Iterator<SelectionKey> itr = this.selector.selectedKeys().iterator();
            while (itr.hasNext()) {
                SelectionKey key = itr.next();
                itr.remove();
                if (!key.isAcceptable()) continue;
                SocketChannel sc = null;
                try {
                    ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                    sc = ssc.accept();
                    if (sc == null) continue;
                    this.setOption(sc);
                    this.recvServer.setChannel(sc);
                }
                catch (Exception e) {
                    if (sc == null) continue;
                    try {
                        sc.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return true;
    }

    private void setOption(SocketChannel channel) throws Exception {
        channel.configureBlocking(false);
        Socket soc = channel.socket();
        soc.setSendBufferSize(131072);
        soc.setReceiveBufferSize(131072);
        soc.setKeepAlive(true);
        soc.setTcpNoDelay(true);
        soc.setReuseAddress(true);
        soc.setSoLinger(true, 5);
    }
}

