/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.WriteDataQueue;
import org.maachang.util.ArrayBinary;
import org.maachang.util.SyncArrayBinary;

public class NioElement {
    private SelectionKey key = null;
    private SocketChannel channel = null;
    private ArrayBinary buffer = null;
    private WriteDataQueue writeBuffer = null;
    private IsWriteQueue isWriteQueue = null;
    private long time = -1L;
    private boolean executionFlag = false;
    private boolean closeFlag = false;
    private Object object = null;

    private NioElement() {
    }

    public NioElement(IsWriteQueue isWriteQueue, SocketChannel channel) throws Exception {
        if (channel == null || !channel.isConnected()) {
            throw new IOException("\u30bd\u30b1\u30c3\u30c8\u30c1\u30e3\u30cd\u30eb\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.channel = channel;
        this.isWriteQueue = isWriteQueue;
        this.writeBuffer = new WriteDataQueue();
        this.buffer = new SyncArrayBinary(512);
        this.time = System.currentTimeMillis();
        this.executionFlag = false;
        this.closeFlag = false;
        this.object = null;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.key != null) {
            try {
                this.key.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.key = null;
        if (this.channel != null) {
            try {
                this.channel.finishConnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.channel.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.channel = null;
        if (this.buffer != null) {
            this.buffer.destroy();
        }
        if (this.writeBuffer != null) {
            this.writeBuffer.destroy();
        }
        this.isWriteQueue = null;
        this.buffer = null;
        this.object = null;
        this.writeBuffer = null;
        this.executionFlag = false;
        this.closeFlag = false;
    }

    public synchronized void setKey(SelectionKey key) {
        this.key = key;
    }

    public synchronized SelectionKey getKey() {
        return this.key;
    }

    public synchronized SocketChannel getChannel() {
        return this.channel;
    }

    public synchronized ArrayBinary getBuffer() {
        return this.buffer;
    }

    public synchronized void startWrite() {
        this.isWriteQueue.append(this);
    }

    public synchronized WriteDataQueue getWriteBuffer() {
        return this.writeBuffer;
    }

    public synchronized void setCloseFlag(boolean mode) {
        this.closeFlag = mode;
    }

    public synchronized boolean isCloseFlag() {
        return this.closeFlag;
    }

    public synchronized void update() {
        this.time = System.currentTimeMillis();
    }

    public synchronized long getTime() {
        return this.time;
    }

    public synchronized void setExecutionFlag(boolean flg) {
        this.executionFlag = flg;
        if (!flg) {
            this.update();
        }
    }

    public synchronized boolean isExecutionFlag() {
        return this.executionFlag;
    }

    public synchronized void setObject(Object object) {
        this.object = object;
    }

    public synchronized Object getObject() {
        return this.object;
    }

    public synchronized boolean isUse() {
        return this.channel != null && this.channel.isConnected() && this.channel.isOpen();
    }
}

