/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.util.ArrayBinary;

class NioInputStream
extends InputStream {
    private static final long TIMEOUT = 5000L;
    private static final long MIN_TIMEOUT = 500L;
    private NioElement element = null;
    private int count = 0;
    private long timeout = -1L;

    private NioInputStream() {
    }

    public NioInputStream(NioElement element) {
        this(element, 5000L);
    }

    public NioInputStream(NioElement element, long timeout) {
        this.element = element;
        this.count = 0;
        this.timeout = timeout <= 500L ? 500L : timeout;
    }

    public void close() {
        this.element = null;
        this.count = 0;
    }

    public int available() throws IOException {
        if (this.element == null || !this.element.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        ArrayBinary bm = this.element.getBuffer();
        return bm.length() - this.count;
    }

    public int read() throws IOException {
        if (this.element == null || !this.element.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3057\u3066\u3044\u307e\u3059");
        }
        ArrayBinary bm = this.element.getBuffer();
        if (bm.length() <= this.count) {
            long time = System.currentTimeMillis();
            while (bm.length() <= this.count) {
                if (time + this.timeout <= System.currentTimeMillis()) {
                    throw new SocketTimeoutException("SocketTimeout");
                }
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {}
            }
        }
        byte ret = bm.getByte(this.count);
        ++this.count;
        return (byte)(ret & 0xFF);
    }

    public boolean markSupported() {
        return false;
    }
}

