/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import org.maachang.comet.net.nio.IsReadQueue;
import org.maachang.comet.net.nio.IsWriteQueue;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.ArrayBinary;
import org.maachang.util.thread.LoopThread;

class NioReceiveServer
extends LoopThread {
    private static final int SELECTOR_TIMEOUT = 5;
    private static final int BUFFER_LENGTH = 512;
    private Selector selector = null;
    private IsReadQueue isRecvQueue = null;
    private IsWriteQueue isWriteQueue = null;
    private ReceiveLinkQueue executionQueue = null;
    private ByteBuffer buffer = null;

    private NioReceiveServer() {
    }

    public NioReceiveServer(ReceiveLinkQueue executionQueue) throws Exception {
        if (executionQueue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.selector = Selector.open();
        this.isRecvQueue = new IsReadQueue();
        this.isWriteQueue = new IsWriteQueue();
        this.executionQueue = executionQueue;
        this.buffer = ByteBuffer.allocateDirect(512);
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    public synchronized void setChannel(SocketChannel channel) throws Exception {
        this.isRecvQueue.append(channel);
    }

    protected void clear() {
        if (this.selector != null) {
            try {
                Iterator<SelectionKey> itr = this.selector.keys().iterator();
                while (itr.hasNext()) {
                    try {
                        SelectionKey key = itr.next();
                        SelectableChannel c = key.channel();
                        c.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selector = null;
        this.isRecvQueue = null;
        this.isWriteQueue = null;
        this.executionQueue = null;
        this.buffer = null;
    }

    protected boolean execution() throws Exception {
        this.setSendRecv();
        while (this.selector.select(5L) > 0) {
            this.setSendRecv();
            Iterator<SelectionKey> itr = this.selector.selectedKeys().iterator();
            while (itr.hasNext()) {
                SelectionKey key = itr.next();
                itr.remove();
                if (key.isValid()) {
                    NioElement em;
                    boolean isReadable = key.isReadable();
                    boolean isWritable = key.isWritable();
                    if (isReadable) {
                        em = null;
                        try {
                            em = (NioElement)key.attachment();
                            if (!this.recv(em)) {
                                em.destroy();
                                continue;
                            }
                            if (!em.isExecutionFlag()) {
                                em.setExecutionFlag(true);
                                this.executionQueue.append(em);
                            }
                            key.interestOps(1);
                        }
                        catch (Exception e) {
                            if (em == null) continue;
                            em.destroy();
                            continue;
                        }
                    }
                    if (!isWritable) continue;
                    em = null;
                    try {
                        em = (NioElement)key.attachment();
                        ByteBuffer buf = em.getWriteBuffer().getQueue();
                        if (buf == null) continue;
                        if (buf.limit() == 0) {
                            if (em.isCloseFlag()) {
                                em.destroy();
                                continue;
                            }
                            key.interestOps(1);
                            continue;
                        }
                        SocketChannel ch = em.getChannel();
                        ch.write(buf);
                    }
                    catch (Exception e) {
                        if (em == null) continue;
                        em.destroy();
                    }
                    continue;
                }
                try {
                    ((NioElement)key.attachment()).destroy();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private void setSendRecv() throws Exception {
        if (this.isRecvQueue.size() > 0) {
            while (this.isRecvQueue.size() > 0) {
                SocketChannel sc = this.isRecvQueue.getQueue();
                if (sc == null) continue;
                NioElement element = new NioElement(this.isWriteQueue, sc);
                SelectionKey key = sc.register(this.selector, 1, element);
                if (key != null) {
                    element.setKey(key);
                    continue;
                }
                element.destroy();
            }
        }
        if (this.isWriteQueue.size() > 0) {
            while (this.isWriteQueue.size() > 0) {
                NioElement element = this.isWriteQueue.getQueue();
                if (!element.isUse() || element.getKey() == null) continue;
                element.getKey().interestOps(5);
            }
        }
    }

    private boolean recv(NioElement emt) throws Exception {
        if (!emt.isUse()) {
            return false;
        }
        ArrayBinary emtBuf = emt.getBuffer();
        SocketChannel channel = emt.getChannel();
        boolean flg = false;
        while (true) {
            this.buffer.clear();
            int len = channel.read(this.buffer);
            if (len <= 0) {
                if (len > -1) break;
                return false;
            }
            this.buffer.flip();
            emtBuf.write(this.buffer);
            flg = true;
        }
        if (flg) {
            emt.update();
        }
        return flg;
    }
}

