/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import java.nio.channels.SocketChannel;
import org.maachang.comet.net.nio.NioReceiveServer;
import org.maachang.comet.net.nio.ReceiveLinkQueue;

class NioReceiveServerArray {
    private static final int DEF_SIZE = 3;
    private NioReceiveServer[] recvs = null;
    private int size = -1;
    private volatile int seq = 0;

    private NioReceiveServerArray() {
    }

    public NioReceiveServerArray(ReceiveLinkQueue queue, int size) throws Exception {
        if (queue == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (size <= 3) {
            size = 3;
        }
        NioReceiveServer[] rv = new NioReceiveServer[size];
        int i = 0;
        while (i < size) {
            rv[i] = new NioReceiveServer(queue);
            ++i;
        }
        this.recvs = rv;
        this.size = size;
        this.seq = 0;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.recvs != null) {
            int len = this.recvs.length;
            int i = 0;
            while (i < len) {
                if (this.recvs[i] != null) {
                    this.recvs[i].destroy();
                }
                this.recvs[i] = null;
                ++i;
            }
            this.recvs = null;
        }
    }

    public synchronized void setChannel(SocketChannel channel) throws Exception {
        if (channel == null) {
            return;
        }
        if (this.recvs == null) {
            channel.close();
            return;
        }
        if (this.seq >= this.size) {
            this.seq = 0;
        }
        this.recvs[this.seq].setChannel(channel);
        ++this.seq;
    }
}

