/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.ssl;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.maachang.conf.Config;
import org.maachang.conf.ConvIniParam;

public class SslOption {
    private static final String SSL_SECTION = "ssl";
    private static final String KEYSTORE_SECTION = "keystore";
    private static final String TRUSTSTORE_SECTION = "truststore";
    public static final String DEFAULT_STORE = "JKS";
    public static final String DEFAULT_MANAGER_ALGORITHM = "SunX509";
    public static final String DEFAULT_SSL_PROTOCOL = "TLS";
    public static final int DEFAULT_PORT = 3443;
    private String keyStore = "JKS";
    private String trustStore = "JKS";
    private String keyStorePasswd = null;
    private String trustPassword = null;
    private String keyManagerAlgorithm = "SunX509";
    private String trustKeyManagerAlgorithm = "SunX509";
    private String sslProtocol = "TLS";
    private String randomAlgorithm = null;
    private String keyStoreFile = null;
    private String trustFile = null;
    private boolean clientAuth = false;
    private int sslPort = 3443;
    private InetAddress sslAddress = null;

    public static final SslOption create(Config conf) {
        SslOption sslOpt = null;
        if (conf.isSection(SSL_SECTION) && ConvIniParam.getBoolean((String)conf.get(SSL_SECTION, SSL_SECTION, 0)) && conf.isSection(KEYSTORE_SECTION) && conf.get(KEYSTORE_SECTION, "key-file", 0) != null) {
            sslOpt = new SslOption();
            Object val = null;
            val = ConvIniParam.getInetAddress((String)conf.get(SSL_SECTION, "address", 0));
            if (val != null) {
                sslOpt.setSslAddress((InetAddress)val);
            }
            if ((val = conf.getIntObject(SSL_SECTION, "port", 0)) != null) {
                sslOpt.setSslPort((Integer)val);
            }
            if ((val = conf.get(SSL_SECTION, "protocol", 0)) != null) {
                sslOpt.setSslProtocol((String)val);
            }
            if ((val = conf.get(SSL_SECTION, "random-algorithm", 0)) != null) {
                sslOpt.setRandomAlgorithm((String)val);
            }
            if (conf.getBoolean(SSL_SECTION, "client-auth", 0)) {
                sslOpt.setClientAuth(true);
            }
            if ((val = conf.get(KEYSTORE_SECTION, "key-store", 0)) != null) {
                sslOpt.setKeyStore((String)val);
            }
            if ((val = conf.get(KEYSTORE_SECTION, "key-manager-algorithm", 0)) != null) {
                sslOpt.setKeyManagerAlgorithm((String)val);
            }
            if ((val = conf.get(KEYSTORE_SECTION, "key-passwd", 0)) != null) {
                sslOpt.setKeyStorePasswd((String)val);
            }
            if ((val = conf.get(KEYSTORE_SECTION, "key-file", 0)) != null) {
                sslOpt.setKeyStoreFile((String)val);
            }
            if (conf.isSection(TRUSTSTORE_SECTION) && conf.getBoolean(TRUSTSTORE_SECTION, "trust", 0)) {
                val = conf.get(TRUSTSTORE_SECTION, "trust-store", 0);
                if (val != null) {
                    sslOpt.setTrustStore((String)val);
                }
                if ((val = conf.get(TRUSTSTORE_SECTION, "trust-manager-algorithm", 0)) != null) {
                    sslOpt.setTrustKeyManagerAlgorithm((String)val);
                }
                if ((val = conf.get(TRUSTSTORE_SECTION, "trust-passwd", 0)) != null) {
                    sslOpt.setTrustPassword((String)val);
                }
                if ((val = conf.get(TRUSTSTORE_SECTION, "trust-file", 0)) != null) {
                    sslOpt.setTrustFile((String)val);
                }
            } else {
                sslOpt.setTrustStore(null);
                sslOpt.setTrustPassword(null);
                sslOpt.setTrustKeyManagerAlgorithm(null);
                sslOpt.setTrustFile(null);
            }
        }
        return sslOpt;
    }

    public static final SSLContext getSslContext(SslOption option) throws Exception {
        if (option == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        KeyManagerFactory keyFactory = null;
        if (option.getKeyStoreFile() != null && option.getKeyStore() != null && option.getKeyManagerAlgorithm() != null) {
            char[] keyStorePasswd = null;
            if (option.getKeyStorePasswd() != null && option.getKeyStorePasswd().length() > 0) {
                keyStorePasswd = option.getKeyStorePasswd().toCharArray();
            }
            KeyStore keyStore = KeyStore.getInstance(option.getKeyStore());
            keyStore.load(new FileInputStream(option.getKeyStoreFile()), keyStorePasswd);
            keyFactory = KeyManagerFactory.getInstance(option.getKeyManagerAlgorithm());
            keyFactory.init(keyStore, keyStorePasswd);
        }
        TrustManagerFactory trustFactory = null;
        if (option.getTrustFile() != null && option.getTrustStore() != null && option.getTrustKeyManagerAlgorithm() != null) {
            char[] trustPasswd = null;
            if (option.getTrustPassword() != null && option.getTrustPassword().length() > 0) {
                trustPasswd = option.getTrustPassword().toCharArray();
            }
            KeyStore trust = KeyStore.getInstance(option.getTrustStore());
            trust.load(new FileInputStream(option.getTrustFile()), trustPasswd);
            trustFactory = TrustManagerFactory.getInstance(option.getTrustKeyManagerAlgorithm());
            trustFactory.init(trust);
        }
        SecureRandom prng = null;
        if (option.getRandomAlgorithm() != null) {
            prng = SecureRandom.getInstance(option.getRandomAlgorithm());
        }
        SSLContext context = SSLContext.getInstance(option.getSslProtocol());
        context.init(keyFactory.getKeyManagers(), trustFactory.getTrustManagers(), prng);
        return context;
    }

    public String getKeyManagerAlgorithm() {
        return this.keyManagerAlgorithm;
    }

    public void setKeyManagerAlgorithm(String keyManagerAlgorithm) {
        if (keyManagerAlgorithm == null || (keyManagerAlgorithm = keyManagerAlgorithm.trim()).length() <= 0) {
            return;
        }
        this.keyManagerAlgorithm = keyManagerAlgorithm;
    }

    public String getTrustKeyManagerAlgorithm() {
        return this.trustKeyManagerAlgorithm;
    }

    public void setTrustKeyManagerAlgorithm(String trustKeyManagerAlgorithm) {
        if (trustKeyManagerAlgorithm == null || (trustKeyManagerAlgorithm = trustKeyManagerAlgorithm.trim()).length() <= 0) {
            return;
        }
        this.trustKeyManagerAlgorithm = trustKeyManagerAlgorithm;
    }

    public String getKeyStore() {
        return this.keyStore;
    }

    public void setKeyStore(String keyStore) {
        if (keyStore == null || (keyStore = keyStore.trim()).length() <= 0) {
            return;
        }
        this.keyStore = keyStore;
    }

    public String getTrustStore() {
        return this.trustStore;
    }

    public void setTrustStore(String trustStore) {
        if (trustStore == null || (trustStore = trustStore.trim()).length() <= 0) {
            return;
        }
        this.trustStore = trustStore;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        if (keyStoreFile == null || (keyStoreFile = keyStoreFile.trim()).length() <= 0) {
            return;
        }
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePasswd() {
        return this.keyStorePasswd;
    }

    public void setKeyStorePasswd(String keyStorePasswd) {
        this.keyStorePasswd = keyStorePasswd;
    }

    public String getTrustPassword() {
        return this.trustPassword;
    }

    public void setTrustPassword(String trustPassword) {
        this.trustPassword = trustPassword;
    }

    public String getRandomAlgorithm() {
        return this.randomAlgorithm;
    }

    public void setRandomAlgorithm(String randomAlgorithm) {
        if (randomAlgorithm == null || (randomAlgorithm = randomAlgorithm.trim()).length() <= 0) {
            return;
        }
        this.randomAlgorithm = randomAlgorithm;
    }

    public String getSslProtocol() {
        return this.sslProtocol;
    }

    public void setSslProtocol(String sslProtocol) {
        if (sslProtocol == null || (sslProtocol = sslProtocol.trim()).length() <= 0) {
            return;
        }
        this.sslProtocol = sslProtocol;
    }

    public String getTrustFile() {
        return this.trustFile;
    }

    public void setTrustFile(String trustFile) {
        if (trustFile == null || (trustFile = trustFile.trim()).length() <= 0) {
            return;
        }
        this.trustFile = trustFile;
    }

    public void setClientAuth(boolean clientAuth) {
        this.clientAuth = clientAuth;
    }

    public boolean isClientAuth() {
        return this.clientAuth;
    }

    public void setSslPort(int sslPort) {
        this.sslPort = sslPort;
    }

    public int getSslPort() {
        return this.sslPort;
    }

    public void setSslAddress(InetAddress sslAddress) {
        this.sslAddress = sslAddress;
    }

    public InetAddress getSslAddress() {
        return this.sslAddress;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(" sslProtocol:" + this.sslProtocol);
        buf.append(" sslPort:" + this.sslPort);
        buf.append(" sslAddress:" + this.sslAddress);
        buf.append(" clientAuth:" + this.clientAuth);
        buf.append(" randomAlgorithm:" + this.sslProtocol);
        buf.append(" keyStore:" + this.keyStore);
        buf.append(" keyManagerAlgorithm:" + this.keyManagerAlgorithm);
        buf.append(" keyStoreFile:" + this.keyStoreFile);
        if (this.trustStore != null) {
            buf.append(" trustStore:" + this.trustStore);
            buf.append(" trustKeyManagerAlgorithm:" + this.trustKeyManagerAlgorithm);
            buf.append(" trustFile:" + this.trustStore);
        }
        return buf.toString();
    }
}

