/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.connector;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.maachang.connector.ClientConnector;
import org.maachang.connector.ConnectorNotHeaderException;
import org.maachang.connector.ExpireConnectException;
import org.maachang.util.ConvertParam;

class SingleClientConnector
implements ClientConnector {
    private static final int BUFFER = 131072;
    private static final int LINGER_TIME = 15;
    private static final long SESSION_TIMEOUT = 30000L;
    private static final String LOCAL_HOST = "127.0.0.1";
    private static final int MAX_BYTE = 0x2000000;
    private InetAddress addr = null;
    private int port = -1;
    private int timeout = -1;
    private byte[] headerBinary = null;
    private Socket socket = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private long updateTime = -1L;

    private SingleClientConnector() {
    }

    public SingleClientConnector(byte[] headerBinary, InetAddress addr, int port, int timeout) throws Exception {
        if (headerBinary == null || headerBinary.length <= 0) {
            throw new IllegalArgumentException("\u30d8\u30c3\u30c0\u30d0\u30a4\u30ca\u30ea\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (addr == null) {
            throw new IllegalArgumentException("\u63a5\u7d9a\u5148\u30a2\u30c9\u30ec\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (port <= -1 || port >= 65536) {
            throw new IllegalArgumentException("\u63a5\u7d9a\u5148\u30dd\u30fc\u30c8\u756a\u53f7\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (timeout <= 0) {
            timeout = 30000;
        }
        this.headerBinary = headerBinary;
        this.addr = addr;
        this.port = port;
        this.timeout = timeout;
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void close() {
        this.destroySocket();
        this.addr = null;
        this.port = -1;
        this.timeout = -1;
        this.headerBinary = null;
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
    }

    public InetAddress getInetAddress() throws Exception {
        return this.addr;
    }

    public int getPort() throws Exception {
        return this.port;
    }

    public byte[] sendReceive(byte[] binary) throws Exception {
        if (binary == null || binary.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ExpireConnectException e = null;
        byte[] ret = null;
        int i = 0;
        while (i < 2) {
            try {
                this.reconnect(false);
                this.setUpdateTime(Long.MAX_VALUE);
                this.outputStream.write(this.headerBinary);
                this.outputStream.write(ConvertParam.convertInt(binary.length + this.headerBinary.length + 4));
                this.outputStream.write(binary);
                this.outputStream.flush();
                ret = this.receive();
                this.updateTime();
                e = null;
                break;
            }
            catch (ExpireConnectException ec) {
                this.destroySocket();
                e = ec;
            }
            catch (Exception ex) {
                this.destroySocket();
                throw e;
            }
            ++i;
        }
        if (e != null) {
            this.destroySocket();
            throw e;
        }
        return ret;
    }

    public boolean isClosed() {
        return this.headerBinary == null;
    }

    private void reconnect(boolean mode) throws Exception {
        if (mode) {
            if (this.isDisconnection()) {
                this.connectSocket();
            } else if (LOCAL_HOST.equals(this.addr.getHostAddress())) {
                this.connectSocket();
            }
        } else if (this.isDisconnection()) {
            this.connectSocket();
        }
    }

    protected boolean isDisconnection() {
        boolean ret = false;
        try {
            long time = this.getUpdateTime();
            if (time <= -1L) {
                this.destroySocket();
                ret = true;
            } else if (this.socket == null || !this.socket.isBound() || this.socket.isClosed()) {
                this.destroySocket();
                ret = true;
            } else if (time != Long.MAX_VALUE && System.currentTimeMillis() >= 30000L + time) {
                this.destroySocket();
                ret = true;
            }
        }
        catch (Exception e) {
            this.destroySocket();
            ret = true;
        }
        return ret;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] receive() throws Exception {
        if (this.socket == null || this.socket.isClosed()) {
            this.destroySocket();
            throw new IOException("\u63a5\u7d9a\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        headerLen = this.headerBinary.length;
        len = -1;
        bs = new ByteArrayOutputStream();
        in = this.inputStream;
        try {
            if (this.socket.isClosed()) {
                bs.close();
                bs = null;
                var11_5 = null;
                return var11_5;
            }
            ret = null;
            cnt = 0;
lbl17:
            // 2 sources

            while (true) {
                block24: {
                    if ((n = in.read()) > -1) break block24;
                    if (len <= -1) {
                        throw new ExpireConnectException("\u901a\u4fe1\u306f\u5207\u65ad\u3055\u308c\u3066\u3044\u307e\u3059");
                    }
                    ** GOTO lbl30
                }
                bs.write(n);
                ++cnt;
                if (len <= -1) {
                    if (cnt < headerLen + 4) continue;
                } else {
                    if (cnt < len) continue;
                    ret = bs.toByteArray();
lbl30:
                    // 2 sources

                    bs.close();
                    bs = null;
                    var11_6 = ret;
                    return var11_6;
                }
                bin = bs.toByteArray();
                i = 0;
                if (true) ** GOTO lbl61
                break;
            }
        }
        catch (ConnectorNotHeaderException ch) {
            this.destroySocket();
            throw ch;
            catch (ExpireConnectException ec) {
                this.destroySocket();
                throw ec;
            }
            catch (Exception e) {
                this.destroySocket();
                throw e;
            }
        }
        finally {
            if (bs != null) {
                try {
                    bs.close();
                }
                catch (Exception var12_7) {}
            }
            bs = null;
        }
        do {
            if (this.headerBinary[i] != bin[i]) {
                throw new ConnectorNotHeaderException("\u901a\u4fe1\u30d8\u30c3\u30c0\u306f\u4e0d\u6b63\u3067\u3059");
            }
            ++i;
lbl61:
            // 2 sources

        } while (i < headerLen);
        len = ConvertParam.convertInt(headerLen, bin);
        if (len <= 0 || len >= 0x2000000) ** break;
        ** while (true)
        this.destroySocket();
        bs.close();
        bs = null;
        throw new IOException("\u6700\u5927\u30b5\u30a4\u30ba\u3092\u8d8a\u3057\u305f\u53d7\u4fe1\u30c7\u30fc\u30bf\u3092\u691c\u77e5\u3057\u307e\u3057\u305f");
    }

    private void connectSocket() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        this.destroySocket();
        Socket socket = null;
        socket = new Socket(this.addr, this.port);
        socket.setSendBufferSize(131072);
        socket.setReceiveBufferSize(131072);
        socket.setKeepAlive(true);
        socket.setTcpNoDelay(true);
        socket.setReuseAddress(true);
        socket.setSoLinger(true, 15);
        socket.setSoTimeout(this.timeout);
        this.socket = socket;
        this.inputStream = new BufferedInputStream(socket.getInputStream());
        this.outputStream = new BufferedOutputStream(socket.getOutputStream());
        this.updateTime();
    }

    protected void destroySocket() {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.outputStream != null) {
            try {
                this.outputStream.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.socket = null;
        this.inputStream = null;
        this.outputStream = null;
        this.setUpdateTime(-1L);
    }

    private synchronized void setUpdateTime(long t) {
        this.updateTime = t;
    }

    private synchronized void updateTime() {
        this.updateTime = System.currentTimeMillis();
    }

    private synchronized long getUpdateTime() {
        return this.updateTime;
    }
}

