/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import java.util.Arrays;

public class IntArray {
    private static final double REDUCTION_ARRAY = 0.375;
    private static final int DEFAULT_START_LENGTH = 8;
    private static final int MAX_START_LENGTH = Integer.MAX_VALUE;
    private static final int MIN_START_LENGTH = 2;
    private static final int NOT_USE = Integer.MAX_VALUE;
    private int[] array = null;
    private int startLength = 8;
    private int length = 8;
    private int nowLength = 0;

    public IntArray() {
    }

    public IntArray(int length) {
        this.length = this.startLength = length < 2 || length > Integer.MAX_VALUE ? 8 : length;
    }

    protected final void finalize() throws Exception {
        try {
            this.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void clear() {
        this.array = null;
        this.length = this.startLength;
        this.nowLength = 0;
    }

    public final void add(Integer value) throws Exception {
        if (value == null) {
            throw new Exception("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.add((int)value);
    }

    public final void add(int value) {
        int[] info = null;
        int[] tmp = null;
        info = this.array;
        int length = this.length;
        int nowSize = this.nowLength;
        if (info == null) {
            info = new int[length];
            Arrays.fill(info, Integer.MAX_VALUE);
            info[nowSize] = value;
            this.array = info;
        } else if (info.length <= nowSize) {
            tmp = info;
            info = new int[length *= 2];
            Arrays.fill(info, Integer.MAX_VALUE);
            System.arraycopy(tmp, 0, info, 0, nowSize);
            info[nowSize] = value;
            this.length = length;
            this.array = info;
        } else {
            info[nowSize] = value;
        }
        ++this.nowLength;
    }

    public final void set(int no, Integer value) throws Exception {
        if (value == null) {
            throw new Exception("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.set(no, (int)value);
    }

    public final void set(int no, int value) throws Exception {
        int nowLen = this.nowLength;
        if (no < 0 || no >= nowLen) {
            throw new Exception("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.array[no] = value;
    }

    public final int remove(int no) {
        int[] info = null;
        int[] tmp = null;
        int ret = Integer.MAX_VALUE;
        int nowSize = this.nowLength;
        int length = this.length;
        if (no < 0 || no >= nowSize || nowSize == 0) {
            return Integer.MAX_VALUE;
        }
        info = this.array;
        ret = info[no];
        info[no] = Integer.MAX_VALUE;
        if (no == 0) {
            tmp = info;
            System.arraycopy(tmp, 1, info, 0, nowSize - 1);
            info[nowSize - 1] = Integer.MAX_VALUE;
        } else if (nowSize - no != 1) {
            tmp = info;
            System.arraycopy(tmp, 0, info, 0, no);
            System.arraycopy(tmp, no + 1, info, no, nowSize - (no + 1));
            info[nowSize - 1] = Integer.MAX_VALUE;
        }
        if (--nowSize != 0 && (double)length * 0.375 >= (double)nowSize) {
            int newLength = length / 2;
            tmp = new int[newLength];
            Arrays.fill(tmp, Integer.MAX_VALUE);
            System.arraycopy(info, 0, tmp, 0, newLength);
            info = null;
            info = tmp;
            this.length = newLength;
        } else if (nowSize == 0) {
            info = null;
        }
        this.array = info;
        this.nowLength = nowSize;
        info = null;
        tmp = null;
        return ret;
    }

    public final int get(int no) {
        if (no < 0 || no >= this.nowLength) {
            return Integer.MAX_VALUE;
        }
        return this.array[no];
    }

    public final int indexOf(int key) {
        return this.indexOf(key, 0);
    }

    public final int indexOf(int key, int index) {
        int ret;
        ret = this.nowLength != 0 ? ((ret = Arrays.binarySearch(this.array, key)) < 0 || ret >= this.nowLength ? -1 : ret) : -1;
        return ret;
    }

    public final int[] getObjects() {
        return this.array;
    }

    public final int size() {
        return this.nowLength;
    }
}

