///////////////////////////////////////////////////////////////////////////////
// maachangCometHTML系の処理メソッド.
// Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved.
///////////////////////////////////////////////////////////////////////////////


////////////////////////////////////////////////////////////////////////////////
// ブラウザ系.
////////////////////////////////////////////////////////////////////////////////

// URL遷移(リダイレクト).
forwardURL = function( url ) {
    if( $base.useString( url ) == true ) {
        window.location = url ;
    }
} ;

// GETパラメータを取得.
$getParams = function() {
    this.params = {} ;
    var s = window.location.search ;
    if( $base.useString( s ) ) {
        var vals = s.substring(1, s.length).split('&') ;
        var len = vals.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( vals[i].indexOf( "=" ) >= 0 ) {
                var kv = vals[i].split('=') ;
                this.params[kv[0]] = kv[1] ;
            }
            else {
                this.params[vals[i]] = "" ;
            }
        }
    }
} ;
$getParams.get = function( key ) {
    if( $base.useString( key ) && useString( this.params[ key ] ) ) {
        return this.params[ key ] ;
    }
    return "" ;
} ;
$getParams.toString = function() {
    var ret = "" ;
    var cnt = 0 ;
    for( var k in this.params ) {
        if( cnt != 0 ) {
            ret += "," ;
        }
        ret += " key:" + k + " value:" + this.params[k] ;
        cnt ++ ;
    }
    return ret ;
} ;

// 指定IDにBase64形式の画像を表示.
viewImageByBase64 = function( id,mimeType,data ) {
    if( $base.isNull( id ) || $base.useString( mimeType ) == false || $base.isNull( data ) ) {
        return ;
    }
    $(id).src = "data:"+mimeType+";base64,"+data ;
} ;

////////////////////////////////////////////////////////////////////////////////
// ドキュメント系.
////////////////////////////////////////////////////////////////////////////////

// 対象スタイルシートにWidht,Heightを割り当てる.
putStyleWidhtHeight = function( clazz,width,height,etc ) {
    var prop = "" ;
    if( width > 0 ) {
        width /= 100 ;
        var x = Math.ceil( bwWidth() * width ) ;
        prop += " width: "+x+"px;" ;
    }
    if( height > 0 ) {
        height /= 100 ;
        var y = Math.ceil( bwHeight() * height ) ;
        prop += " height: "+y+"px;" ;
    }
    if( etc != null && ( etc = trim( etc ) ).length > 0 ) {
        prop += etc ;
        if( endsWith( etc,";" ) == false ) {
            prop += ";" ;
        }
    }
    if( prop.length > 0 ) {
        addCssValue( clazz,prop ) ;
    }
} ;

// ブラウザWidthを取得.
bwWidth = function() {
    if( isMSIE == true ) {
        return document.body.clientWidth ;
    }
    else {
        return window.innerWidth ;
    }
} ;

// ブラウザHeightを取得.
bwHeight = function() {
    if( isMSIE == true ) {
        return document.body.clientHeight ;
    }
    else {
        return window.innerHeight ;
    }
} ;

// クラス情報を取得.
getElementsByClassName = function(clazz) {
    var ret = [];
    var elems = (document.getElementsByTagName("*") || document.all);
    for (var i = 0; i < elems.length; i++) {
        if (elems[i].className == clazz) {
            ret[ret.length] = elems[i];
        }
    }
    return ret;
}

////////////////////////////////////////////////////////////////////////////////
// スタイルシート書き換え.
////////////////////////////////////////////////////////////////////////////////

// スタイルシートを書き換える.
addCssValue = function( selector, property ) {
    if( $base.isNull( selector ) || $base.isNull( property ) ) {
        return false ;
    }
    var sheets = getSheets() ;
    if( $base.isNull( sheets ) ) {
        return false ;
    }
    if( isMSIE == true ) {
        if( sheets[0].addRule ) { //IE
            sheets[0].addRule( selector, "{" + property + "}" );
            return true ;
        }
    }
    else {
        if( sheets[0].insertRule ) { //Mozilla
            sheets[0].insertRule( selector + "{" + property + "}", sheets[0].cssRules.length );
            return true ;
        }
    }
    return false;
}

// スタイルシートを取得する.
getCssValue = function( selector, property ) {
    var property = ( property.match( /-/ ) ) ? property.camelize( ) : property;
    var stylesheets = null ;
    var sheets = getSheets() ;
    if( $base.isNull( sheets ) ) {
        return false ;
    }
    if( isMSIE == true ) {
        stylesheets = sheets[0].rules        //IE
    }
    else {
        stylesheets = sheets[0].cssRules;    //Mozilla
    }
    for( var i = 0, len = stylesheets.length; i < len; i++ ) {
        var css = stylesheets[i];
        if( css.selectorText.toLowerCase( ) == selector.toLowerCase( ) ) {
            return css.style[ property ];
        }
    }
}

// 指定要素での有効スタイルシート値を取得.
getActiveCssValue = function( element, property, pseudo ) {
    var sheets = getSheets() ;
    if( $base.isNull( sheets ) ) {
        return false ;
    }
    if( $base.isMSIE == true ) {
        if( element.currentStyle ) {          //IE
            var property = ( property.match( /-/ ) ) ? property.camelize( ) : property;
            return element.currentStyle[ property.camelize( ) ];
        }
    }
    else {
        if( document.defaultView.getComputedStyle ) {    //Mozilla
            var property = ( isNull( property.match( /-/ ) ) ) ? property.deCamelize( ) : property;
            return document.defaultView.getComputedStyle( element, pseudo ).getPropertyValue( property );
        }
    }
    return "";
}

// スタイルシート一覧を取得.
getSheets = function() {
    if ( document.styleSheets &&
        document.styleSheets[0] &&
        document.styleSheets[0].title != null ) {
        return document.styleSheets;
    }
    return null ;
}

////////////////////////////////////////////////////////////////////////////////
// Cookie系.
////////////////////////////////////////////////////////////////////////////////

// cookie取得.
getCookie = function(key,  tmp1, tmp2, xx1, xx2, xx3) {
    if( isCookie == false ) {
        return  ;
    }
    tmp1 = " " + document.cookie + ";";
    xx1 = xx2 = 0;
    len = tmp1.length;
    while (xx1 < len) {
        xx2 = tmp1.indexOf(";", xx1);
        tmp2 = tmp1.substring(xx1 + 1, xx2);
        xx3 = tmp2.indexOf("=");
        if (tmp2.substring(0, xx3) == key) {
            return(unescape(tmp2.substring(xx3 + 1, xx2 - xx1 - 1)));
        }
        xx1 = xx2 + 1;
    }
    return("");
}

// cookie登録.
setCookie = function(key, val, tmp) {
    if( isCookie == false ) {
        return  ;
    }
    tmp = key + "=" + escape(val) + "; ";
    tmp += "expires=Tue, 31-Dec-2030 23:59:59; ";
    document.cookie = tmp;
}

// cookie削除.
clearCookie = function(key) {
    if( isCookie == false ) {
        return  ;
    }
    document.cookie = key + "=" + "x; expires=Tue, 1-Jan-1980 00:00:00;";
}


