package org.maachang.comet;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.conf.BaseConfig;
import org.maachang.comet.conf.IniFile;
import org.maachang.comet.conf.StartupConfig;
import org.maachang.comet.httpd.engine.script.cache.CacheScriptByDirectorys;
import org.maachang.conf.ConvIniParam;
import org.maachang.shutdown.SendShutdown;
import org.maachang.util.FileUtil;

/**
 * MaachangCometシャットダウン処理.
 * 
 * @version 2007/11/17
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class Shutdown {
    
    /**
     * LOG.
     */
    private static final Log LOG = LogFactory.getLog( CacheScriptByDirectorys.class ) ;
    
    /**
     * １回のシャットダウン待ち.
     */
    private static final int TIMEOUT = 5000 ;
    
    /**
     * シャットダウンリトライ数.
     */
    private static final int RETRY = 12 ;
    
    /**
     * メインメソッド.
     * <BR><BR>
     * @param args Javaからのパラメータが設定されます.
     * @exception Exception 例外.
     */
    public static final void main( String[] args )
        throws Exception {
        new Shutdown().execution( args ) ;
    }
    
    /**
     * 実行処理.
     */
    private void execution( String[] args )
        throws Exception {
        int port = getPort() ;// プロジェクトシャットダウンポートを取得.
        if( args != null || args.length >= 1 ) {
            int argsPort = -1 ;
            try {
                argsPort = Integer.parseInt( args[ 0 ] ) ;
            } catch( Exception e ) {
                argsPort = -1 ;
            }
            if( argsPort > 0 && argsPort <= 65535 ) {
                port = argsPort ;
            }
        }
        if( LOG.isDebugEnabled() ) {
            LOG.debug( "# シャットダウン処理を実施:" + port  ) ;
        }
        int exitCode = 0 ;
        boolean retry = false ;
        try {
            for( int i = 0 ; i < RETRY ; i ++ ) {
                if( new SendShutdown().send( port,TIMEOUT ) == true ) {
                    if( LOG.isDebugEnabled() ) {
                        LOG.debug( "# シャットダウン処理終了" ) ;
                    }
                    retry = true ;
                    break ;
                }
            }
            if( retry == false ) {
                if( LOG.isDebugEnabled() ) {
                    LOG.debug( "# シャットダウン終了通知がありません" ) ;
                }
                exitCode = -1 ;
            }
        } catch( Exception e ) {
            if( LOG.isDebugEnabled() ) {
                LOG.debug( "# シャットダウン処理でエラー",e ) ;
            }
            exitCode = -1 ;
        }
        System.exit( exitCode ) ;
    }
    
    /**
     * コンフィグ情報から、シャットダウン監視ポート番号を取得.
     */
    private static final int getPort() throws Exception {
        String path = StartupConfig.getPath( "." ) ;
        String confPath = path+MaachangDef.DIRECTORY_CONFIG ;
        confPath = FileUtil.getFullPath( confPath )+FileUtil.FILE_SPACE ;
        BaseConfig conf = StartupConfig.getBaseConfig( confPath ) ;
        
        // 拡張コンフィグファイルを取得.
        int len = conf.size() ;
        IniFile config = new IniFile() ;
        for( int i = 0 ; i < len ; i ++ ) {
            String name = conf.getConfig( i ) ;
            if( name == null || ( name = name.trim() ).length() <= 0 ) {
                continue ;
            }
            StartupConfig.readConfig( config,confPath,name ) ;
        }
        
        // 拡張コンフィグのシャットダウンポートを取得.
        return ConvIniParam.getInt( config.get( "server","shutdown-port",0 ) ) ;
    }
    
}

