package org.maachang.comet.httpd ;

/**
 * HTTPD-Version-Define.
 *
 * @version 2007/08/19
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class HttpdVersionDef {
    
    private HttpdVersionDef() {
        
    }
    
    /**
     * 名前を取得.
     * <BR><BR>
     * 名前を取得します.
     * <BR>
     * @return String 名前が返されます.
     */
    public static final String getName() {
        return "MaachangComet" ;
    }
    
    /**
     * バージョンを取得.
     * <BR><BR>
     * バージョン値を取得します.
     * <BR>
     * @return String バージョン値が返されます.
     */
    public static final String getVersion() {
        return "b1.1C" ;
    }
    
    /**
     * 作成日を取得.
     * <BR><BR>
     * 作成日を取得します.
     * <BR>
     * @return String 作成日が返されます.
     */
    public static final String getDate() {
        return "2008/05/31" ;
    }
    
    /**
     * copyright.
     * <BR><BR>
     * copyrightを取得します.
     * <BR>
     * @return String copyrightが返されます.
     */
    public static final String getCopyright() {
        return "Copyright (c) 2007 masahito suzuki, Inc. All Rights Reserved." ;
    }
    
    /**
     * サーバ名を取得.
     * <BR><BR>
     * サーバ名が返されます.
     * <BR>
     * @return String サーバ名が返されます.
     */
    public static final String getServerName() {
        return new StringBuilder().append( getName() ).
            append( "-" ).append( getVersion() ).toString() ;
    }
    
    /**
     * 表示用サーバ名を取得.
     * <BR><BR>
     * 表示用のサーバ名を取得します.
     * <BR>
     * @return Stirng 表示用サーバ名が返されます.
     */
    public static final String getPrintServerName() {
        return new StringBuilder().append( getName() ).
            append( "-" ).append( getVersion() ).append( "[ver." ).
            append( getVersion() ).append( " " ).append( getDate() ).
            append( "]" ).toString() ;
    }
}

