package org.maachang.comet.net.nio ;

import java.nio.channels.SocketChannel;
import java.util.LinkedList;

/**
 * 読み込み可能キュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class IsReadQueue {
    private LinkedList<SocketChannel> queue = null ;
    
    public IsReadQueue() {
        queue = new LinkedList<SocketChannel>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( SocketChannel accept ) {
        if( queue == null || accept == null ) {
            return ;
        }
        queue.add( accept ) ;
    }
    
    public synchronized SocketChannel getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    public synchronized int size() {
        return queue.size() ;
    }
}
