package org.maachang.comet.net.nio ;

import java.nio.ByteBuffer;
import java.util.LinkedList;

/**
 * 書き込み処理を行うデータを管理するキュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class WriteDataQueue {
    private LinkedList<ByteBuffer> queue = null ;
    
    public WriteDataQueue() {
        queue = new LinkedList<ByteBuffer>() ;
    }
    
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    public synchronized void append( ByteBuffer accept ) {
        if( queue == null || accept == null ) {
            return ;
        }
        queue.add( accept ) ;
    }
    
    public synchronized ByteBuffer getQueue() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    public synchronized int size() {
        return queue.size() ;
    }
}
