//
// JSONP-RPCスクリプト.
//

////////////////////////////////////////////////////////////////////////////////
// JSONPスクリプトパターンからコールバックされるメソッド.
////////////////////////////////////////////////////////////////////////////////

var _$function$_call_JSONP_RPC_AccessMethod = function() {
    if( __$type$script == "script" ) {
        if( getHttpMethod() != "GET" ) {
            exit( "error405" ) ;
        }
        var jargsString = $("jargs") ;
        var callbackMethod = $("callback") ;
        var id = $("jid") ;
        // ブラウザがIE以外の場合は、スクリプトタグ削除を行わない.
        if( useString( $("ie") ) == false ||
            $("ie") == "0" ) {
            id = null ;
        }
        var ret = null ;
        // mainメソッドが存在しない場合.
        if( isNull( scriptMemorys.main ) ) {
            ret = rpc.encodeJSON( rpc.createError(
                "mainメソッドが定義されていません" ) ) ;
        }
        // mainがメソッドでない場合.
        else if( valueof( scriptMemorys.main ) != "function" ) {
            ret = rpc.encodeJSON( rpc.createError(
                "mainはメソッドではありません" ) ) ;
        }
        else {
            try {
                var tmp = null ;
                // 引数が設定されていない場合.
                if( useString( jargsString ) == false ) {
                    tmp = main() ;
                }
                // 引数が設定されている場合.
                else {
                    jargsString = jargsString.substring( 1,jargsString.length()-1 ) ;
                    tmp = main( decodeJSON( jargsString ) ) ;
                }
                // 実行結果が正常の場合.
                if( rpc.isError( tmp ) == false ) {
                    tmp = rpc.createSuccess( tmp ) ;
                }
                jargsString = null ;
                // １つの配列指定の場合は、配列内部を戻り値とする.
                if( valueof( tmp ) == "array" && tmp.length == 1 ) {
                    tmp = tmp[ 0 ] ;
                }
                // 文字列に変換.
                ret = rpc.encodeJSON( tmp ) ;
                tmp = null ;
            } catch( e ) {
                _isExitTo() ;// スクリプト終了チェック.
                warnLog( e ) ;// 警告ログ.
                // 例外の場合、例外内容を返す.
                ret = rpc.encodeJSON( rpc.createError(e.toString()) ) ;
            }
        }
        // 戻り情報を生成.
        var result = "" ;
        // callbackメソッドが設定されていない場合は、JSON形式のみを返す.
        if( useString( callbackMethod ) == false ) {
            result = ret ;
        }
        else {
            if( useString( id ) == true ) {
                // IEの場合、スクリプトタグを、削除する処理を設定する.
                result = "document.body.removeChild($(\""+id+"\")) ;\n" ;
                id = null ;
            }
            result = result + callbackMethod + "(" + ret + ") ;\n" ;
        }
        return result ;
    }
    return "" ;
} ;

////////////////////////////////////////////////////////////////////////////////
// AjaxRPCスクリプトパターンからコールバックされるメソッド.
////////////////////////////////////////////////////////////////////////////////

var _$function$_call_AJAX_RPC_AccessMethod = function() {
    if( __$type$script == "script" ) {
        if( getHttpMethod() != "POST" ) {
            exit( "error405" ) ;
        }
        var jargsString = $("jargs") ;
        var ret = null ;
        // mainメソッドが存在しない場合.
        if( isNull( scriptMemorys.main ) ) {
            ret = rpc.encodeJSON( rpc.createError(
                "mainメソッドが定義されていません" ) ) ;
        }
        // mainがメソッドでない場合.
        else if( valueof( scriptMemorys.main ) != "function" ) {
            ret = rpc.encodeJSON( rpc.createError(
                "mainはメソッドではありません" ) ) ;
        }
        else {
            try {
                var tmp = null ;
                // 引数が設定されていない場合.
                if( useString( jargsString ) == false ) {
                    tmp = main() ;
                }
                // 引数が設定されている場合.
                else {
                    jargsString = jargsString.substring( 1,jargsString.length()-1 ) ;
                    tmp = main( decodeJSON( jargsString ) ) ;
                }
                // 実行結果が正常の場合.
                if( rpc.isError( tmp ) == false ) {
                    tmp = rpc.createSuccess( tmp ) ;
                }
                jargsString = null ;
                // １つの配列指定の場合は、配列内部を戻り値とする.
                if( valueof( tmp ) == "array" && tmp.length == 1 ) {
                    tmp = tmp[ 0 ] ;
                }
                // 文字列に変換.
                ret = rpc.encodeJSON( tmp ) ;
                tmp = null ;
            } catch( e ) {
                _isExitTo() ;// スクリプト終了チェック.
                warnLog( e ) ;// 警告ログ.
                // 例外の場合、例外内容を返す.
                ret = rpc.encodeJSON( rpc.createError(e.toString()) ) ;
            }
        }
        return ret ;
    }
    return "" ;
} ;

////////////////////////////////////////////////////////////////////////////////
// RPC操作系処理.
////////////////////////////////////////////////////////////////////////////////

// RPCオブジェクト.
rpc = {
    // 正常結果を生成.
    createSuccess : function( data ) {
        if( isNull( data ) ) {
            data = "" ;
        }
        return {"result":"success","value":data} ;
    },
    // エラーメッセージを生成.
    createError : function( message ) {
        if( useString( message ) == false ) {
            message = "no message" ;
        }
        return {"result":"error","value":message} ;
    },
    // 戻り値が正常か、エラーかを判別します.
    isError : function( result ) {
        if( isNull( result ) ) {
            return false ;
        }
        if( isNull( result.result ) == false &&
            result.result == "error" ) {
            return true ;
        }
        return false ;
    },
    // 戻り値データを取得.
    getResult : function( data ) {
        if( isNull( data ) || isNull( data.value ) ) {
            return "" ;
        }
        return data.value ;
    },
    // json形式の文字列変換.
    encodeJSON : function( data ) {
        var buf = new StrBuf() ;
        encodeJSON( data,buf ) ;
        return buf.toString() ;
    }
} ;

////////////////////////////////////////////////////////////////////////////////
// JSONP-RPC操作系処理.
////////////////////////////////////////////////////////////////////////////////

// JSONP-RPCオブジェクト.
jsonpRPC = {
    // [createFunction]でhttpClient送信するときのUserAgent.
    USER_AGENT : "MaachangComet["+version()+"]/Jsonp-Rpc",
    // HttpClient接続で、JSONP-RPC接続を行うメソッドを生成.
    createFunction : function( url,methodName ) {
        if( useString( url ) == false || valueof( url ) != "string" ) {
            throw new IllegalArgumentException( "(serverJsonpRpc.createFunction):urlは不正です" ) ;
        }
        if( isNull( methodName ) || valueof( methodName ) != "string" ) {
            throw new IllegalArgumentException( "(serverJsonpRpc.createFunction):methodNameは不正です" ) ;
        }
        // url+method名を生成.
        var baseUrl = url ;
        if( startsWith( baseUrl,"http://" ) == false &&
            startsWith( baseUrl,"https://" ) == false ) {
            baseUrl = "http://" + baseUrl ;
        }
        // メソッド名をURL変換[.区切りを省く].
        var lst = methodName.split( "." ) ;
        var len = lst.length - 1 ;
        var readUrl = "" ;
        for( var i = 0 ; i < len ; i ++ ) {
            if( i != 0 ) {
                readUrl += "/" ;
            }
            readUrl += trim( lst[ i ] ) ;
        }
        var last = trim( lst[ len ] ) ;
        lst = null ;
        var p = last.indexOf( "(" ) ;
        if( p >= 0 ) {
            last = last.substring( 0,p ) ;
        }
        if( endsWith( last,"Jsonp" ) == false ) {
            last = last + "Jsonp" ;
        }
        if( endsWith( last,".ms" ) == false ) {
            last = last + ".ms" ;
        }
        readUrl += "/" + last ;
        last = null ;
        
        // 接続先のURLとして整形.
        if( endsWith( readUrl,"/" ) == false &&
            startsWith( readUrl,"/" ) == false ) {
            readUrl = "/" + readUrl ;
        }
        readUrl = baseUrl + readUrl ;
        
        // 生成メソッドを返す.
        return function() {
            // パラメータ引数をJSON形式に変換.
            var len = arguments.length ;
            var jargs = [] ;
            if( len == 1 ) {
                jargs = arguments[ 0 ] ;
            }
            else {
                for( var i = 0 ; i < len ; i ++ ) {
                    var arg = arguments[ i ] ;
                    jargs[ jargs.length ] = arg ;
                }
            }
            // IEでアクセスしていないのでFlagOFF.
            var params = "&ie=0" ;
            // JSONP引数.
            if( jargs.length > 0 ) {
                params += "&jargs="+ encodeURL( rpc.encodeJSON( jargs ) ) ;
            }
            // 接続処理.
            try {
                var ret = HttpClient.connection( "GET",readUrl+"?"+params,null,null,jsonpRPC.USER_AGENT ) ;
                if( isNull( ret ) || ret.state != 200 ) {
                    if( isNull( ret ) ) {
                        return rpc.createError( "no-data" ) ;
                    }
                    else {
                        return rpc.createError( "error " + ret.state ) ;
                    }
                }
                ret = convertBinaryByString( ret.body,"UTF8" ) ;
                return decodeJSON( ret ) ;
            } catch( e ) {
                _isExitTo() ;// スクリプト終了チェック.
                return rpc.createError( e.toString() ) ;
            }
        }
    }
} ;

