/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import org.maachang.comet.httpd.HttpdExecutionManager;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.EvalJavascript;
import org.maachang.comet.httpd.engine.HttpdDef;
import org.maachang.comet.httpd.engine.HttpdResponseInstance;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

class HttpdPublicManager
implements HttpdExecutionManager {
    private String publicDirectory = null;

    private HttpdPublicManager() {
    }

    public HttpdPublicManager(String currentDirectory) throws Exception {
        this.publicDirectory = ScriptDef.trimCurrentDirectory(currentDirectory) + "public/";
    }

    protected void finalize() throws Exception {
        this.publicDirectory = null;
    }

    public HttpdResponse get(HttpdRequest request) throws Exception {
        HttpdResponse ret;
        block29: {
            if (request == null) {
                throw new HttpdStateException(400, "\u30ea\u30af\u30a8\u30b9\u30c8\u304c\u4e0d\u6b63\u3067\u3059");
            }
            ret = null;
            try {
                String path = this.getUsePath(request.getUrlPath());
                this.pushUrl(request, path);
                if (!FileUtil.isFileExists((String)path)) break block29;
                if (!FileUtil.isRead((String)path)) {
                    throw new HttpdStateException(403, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306f\u8aad\u307f\u8fbc\u307f\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093");
                }
                ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                ret.setCookieSession(request);
                ret.getHeader().setHeader("Last-Modified", HttpdTimestamp.getTimestamp(FileUtil.getLastTime((String)path)));
                ret.getHeader().setHeader("Content-Length", String.valueOf(FileUtil.getLength((String)path)));
                ret.setHttpClose(false);
                if (path.endsWith(".js")) {
                    String js = FileUtil.getFileByString((String)path, (String)"UTF8");
                    js = EvalJavascript.convert(request, js);
                    OutputStream out = null;
                    try {
                        byte[] bin = js.getBytes("UTF8");
                        js = null;
                        ret.getHeader().setHeader("Content-Length", String.valueOf(bin.length));
                        out = ret.getOutput();
                        out.write(bin);
                        js = null;
                        out.flush();
                        out.close();
                        out = null;
                        break block29;
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                BufferedInputStream bi = null;
                OutputStream out = null;
                try {
                    bi = new BufferedInputStream(new FileInputStream(path));
                    out = ret.getOutput();
                    byte[] bin = new byte[1024];
                    while (true) {
                        int len;
                        if ((len = bi.read(bin)) <= 0) {
                            if (len > -1) continue;
                            break;
                        }
                        out.write(bin, 0, len);
                    }
                    out.flush();
                    out.close();
                    out = null;
                    bi.close();
                    bi = null;
                }
                finally {
                    if (bi != null) {
                        try {
                            bi.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (Exception e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
        }
        return ret;
    }

    public long getFileTime(String path) {
        if (FileUtil.isFileExists((String)(path = this.getUsePath(path))) && FileUtil.isRead((String)path)) {
            return FileUtil.getLastTime((String)path);
        }
        return -1L;
    }

    public boolean isPath(String path) {
        return FileUtil.isFileExists((String)(path = this.getUsePath(path)));
    }

    public boolean isRead(String path) {
        if (FileUtil.isFileExists((String)(path = this.getUsePath(path)))) {
            return FileUtil.isRead((String)path);
        }
        return false;
    }

    private final String getUsePath(String path) {
        if ("/favicon.ico".endsWith(path)) {
            path = String.valueOf(this.publicDirectory) + "img/" + "/favicon.ico".substring(1, "/favicon.ico".length());
            if (!FileUtil.isFileExists((String)path)) {
                path = this.publicDirectory + "/favicon.ico".substring(1, "/favicon.ico".length());
            }
        } else {
            if (path.startsWith("/")) {
                path = path.substring(1, path.length());
            }
            if ((path = String.valueOf(this.publicDirectory) + path).endsWith("/")) {
                int len = HttpdDef.INDEX_HTML.length;
                int i = 0;
                while (i < len) {
                    String ph = String.valueOf(path) + HttpdDef.INDEX_HTML[i];
                    if (FileUtil.isFileExists((String)ph)) {
                        path = ph;
                        break;
                    }
                    ++i;
                }
            }
        }
        return path;
    }

    private final void pushUrl(HttpdRequest request, String path) throws Exception {
        String str = FileUtil.getFullPath((String)"public/");
        path = FileUtil.getFullPath((String)path);
        path = path.substring(str.length(), path.length());
        if (!(path = StringUtil.changeString((String)path, (String)"\\", (String)"/")).startsWith("/")) {
            path = "/" + path;
        }
        request.setUrlPath(path);
    }
}

