/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.net.nio;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.net.HttpdRequestImpl;
import org.maachang.comet.net.ReadHttpdRequest;
import org.maachang.comet.net.nio.ConnectionInfo;
import org.maachang.comet.net.nio.ConnectionInfoImpl;
import org.maachang.comet.net.nio.HttpReceiveCallback;
import org.maachang.comet.net.nio.NioElement;
import org.maachang.comet.net.nio.ReceiveLinkQueue;
import org.maachang.util.SequenceSync;
import org.maachang.util.thread.LoopThread;

class NioPoolThread
extends LoopThread {
    private static final Log LOG = LogFactory.getLog(NioPoolThread.class);
    private static final long TIMEOUT = 5000L;
    private HttpReceiveCallback call = null;
    private ReceiveLinkQueue queue = null;
    private SequenceSync sequence = null;

    private NioPoolThread() {
    }

    public NioPoolThread(HttpReceiveCallback call, ReceiveLinkQueue queue, SequenceSync sequence) throws Exception {
        if (call == null || queue == null || sequence == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.call = call;
        this.queue = queue;
        this.sequence = sequence;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        this.queue = null;
        this.call = null;
    }

    protected boolean execution() throws Exception {
        NioElement element = null;
        try {
            element = this.queue.getQueue();
            if (element != null) {
                this.executionServer(element);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (element != null) {
                element.destroy();
            }
            element = null;
            throw e;
        }
    }

    private void executionServer(NioElement element) throws Exception {
        try {
            int id = this.sequence.getId();
            ConnectionInfoImpl info = new ConnectionInfoImpl(element);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("receive(" + id + ") - [" + info.getInetAddress().getHostAddress() + ":" + info.getPort() + "]"));
            }
            HttpdRequestImpl req = NioPoolThread.readHttpdRequest(info, id);
            req.setConnectionInfo(info);
            this.call.execution(info, id, req);
            if (info.isUse()) {
                if (info.isCloseFlag()) {
                    element.setCloseFlag(true);
                } else if (!info.recyclingConnection()) {
                    element.setCloseFlag(true);
                } else {
                    element.setCloseFlag(false);
                }
            } else {
                element.destroy();
            }
        }
        catch (Exception e) {
            if (element != null) {
                element.destroy();
            }
            element = null;
            throw e;
        }
    }

    private static final HttpdRequestImpl readHttpdRequest(ConnectionInfo info, int seqId) throws Exception {
        if (info == null || !info.isUse()) {
            return null;
        }
        try {
            HttpdRequestImpl ret;
            HttpdRequestImpl httpdRequestImpl = ret = ReadHttpdRequest.receiveHttpRequest(info.getInputStream(5000L), seqId);
            return httpdRequestImpl;
        }
        finally {
            info.getElement().getBuffer().reset();
        }
    }
}

