/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.nio.ByteBuffer;
import java.util.LinkedList;

class M2Buffers {
    private LinkedList<ByteBuffer> queue = new LinkedList();

    public M2Buffers(int size, int bufferLength) {
        int i = 0;
        while (i < bufferLength) {
            this.queue.add(ByteBuffer.allocateDirect(size));
            ++i;
        }
    }

    public synchronized void destroy() {
        if (this.queue != null) {
            this.queue.clear();
        }
    }

    public synchronized void append(ByteBuffer element) {
        if (element == null || element == null) {
            return;
        }
        this.queue.add(element);
    }

    public synchronized ByteBuffer getQueue() {
        if (this.queue == null || this.queue.size() <= 0) {
            return null;
        }
        return this.queue.removeFirst();
    }

    public synchronized int size() {
        return this.queue.size();
    }
}

