/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.util.Enumeration;
import org.maachang.dbm.engine.M2Enumeration;
import org.maachang.dbm.engine.M2Key;
import org.maachang.dbm.engine.M2Lock;
import org.maachang.dbm.engine.M2NextKey;
import org.maachang.dbm.engine.M2Sector;
import org.maachang.dbm.engine.M2SectorData;
import org.maachang.util.FnvHash;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class M2Engine {
    private M2Key key = null;
    private M2Sector sector = null;
    private final M2Lock nsync = new M2Lock();
    private final Object sync = new Object();

    private M2Engine() {
    }

    public M2Engine(M2Key key, M2Sector sector) throws Exception {
        if (key == null || sector == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.key = key;
        this.sector = sector;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.sector != null) {
                this.sector.destroy();
            }
            this.key = null;
            this.sector = null;
        }
    }

    public void put(byte[] key, byte[] value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int code = FnvHash.fnv32a((byte[])key);
        this.nsync.lock(code);
        try {
            long vp = this.sector.writeAll(value, 0, value.length);
            this.key.add(code, key, (int)(vp & 0xFFFFFFFFL), (int)((vp & 0xFFFFFFFF00000000L) >> 32));
        }
        finally {
            this.nsync.unlock(code);
        }
    }

    public void remove(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        int code = FnvHash.fnv32a((byte[])key);
        this.nsync.lock(code);
        try {
            this.key.remove(code, key);
        }
        finally {
            this.nsync.unlock(code);
        }
    }

    public byte[] get(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = null;
        int code = FnvHash.fnv32a((byte[])key);
        this.nsync.lock(code);
        try {
            long vp = this.key.get(code, key);
            if (vp >= 0L) {
                ret = this.sector.readAll((int)(vp & 0xFFFFFFFFL), (int)((vp & 0xFFFFFFFF00000000L) >> 32));
            }
        }
        finally {
            this.nsync.unlock(code);
        }
        return ret;
    }

    public boolean containsKey(byte[] key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        boolean ret = false;
        int code = FnvHash.fnv32a((byte[])key);
        this.nsync.lock(code);
        try {
            long vp = this.key.get(code, key);
            ret = vp >= 0L;
        }
        finally {
            this.nsync.unlock(code);
        }
        return ret;
    }

    public int write(byte[] key, byte[] value, int pos, int off, int length) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (off <= 0) {
            off = 0;
        }
        if (length <= 0) {
            length = value.length;
        }
        if (off + length >= value.length) {
            length = value.length - off;
        }
        int ret = 0;
        int code = FnvHash.fnv32a((byte[])key);
        this.nsync.lock(code);
        try {
            long vp = this.key.get(code, key);
            if (vp <= -1L) {
                return -1;
            }
            int p = 0;
            int pnt = (int)(vp & 0xFFFFFFFFL);
            int fileNo = (int)((vp & 0xFFFFFFFF00000000L) >> 32);
            M2SectorData data = new M2SectorData();
            while (true) {
                this.sector.readOne(data, pnt, fileNo);
                int len = data.getLength();
                if (p + len > pos) {
                    int st = pos - p;
                    if (st <= -1) {
                        st = 0;
                    }
                    byte[] b = data.getData();
                    int i = st;
                    while (i < len) {
                        if (ret >= length) {
                            this.sector.writeOne(data, pnt, fileNo);
                            int n = ret;
                            return n;
                        }
                        b[i] = value[off];
                        ++off;
                        ++ret;
                        ++i;
                    }
                    this.sector.writeOne(data, pnt, fileNo);
                }
                if (data.getNextNo() <= -1) break;
                if (data.getNextFileNo() <= -1) {
                    break;
                }
                p += len;
                pnt = data.getNextNo();
                fileNo = data.getNextFileNo();
            }
        }
        finally {
            this.nsync.unlock(code);
        }
        return ret;
    }

    public int read(byte[] key, byte[] value, int pos, int off, int length) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (off <= 0) {
            off = 0;
        }
        if (length <= 0) {
            length = value.length;
        }
        if (off + length >= value.length) {
            length = value.length - off;
        }
        int ret = 0;
        int code = FnvHash.fnv32a((byte[])key);
        this.nsync.lock(code);
        try {
            long vp = this.key.get(code, key);
            if (vp <= -1L) {
                return -1;
            }
            int p = 0;
            int pnt = (int)(vp & 0xFFFFFFFFL);
            int fileNo = (int)((vp & 0xFFFFFFFF00000000L) >> 32);
            M2SectorData data = new M2SectorData();
            while (true) {
                this.sector.readOne(data, pnt, fileNo);
                int len = data.getLength();
                if (p + len > pos) {
                    int st = pos - p;
                    if (st <= -1) {
                        st = 0;
                    }
                    byte[] b = data.getData();
                    int i = st;
                    while (i < len) {
                        if (ret >= length) {
                            int n = ret;
                            return n;
                        }
                        value[off] = b[i];
                        ++off;
                        ++ret;
                        ++i;
                    }
                }
                if (data.getNextNo() <= -1) break;
                if (data.getNextFileNo() <= -1) {
                    break;
                }
                p += len;
                pnt = data.getNextNo();
                fileNo = data.getNextFileNo();
            }
        }
        finally {
            this.nsync.unlock(code);
        }
        return ret;
    }

    public M2NextKey next(M2NextKey nextKey) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.key.nextKey(nextKey);
    }

    public Enumeration<byte[]> elements() {
        return new M2Enumeration(this);
    }

    public long sequenceId(int no) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.key.getHash().sequenceId(no);
    }

    public int size() {
        int ret = -1;
        try {
            if (this.isUse()) {
                ret = this.key.size();
            }
        }
        catch (Exception e) {
            ret = -1;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.key != null && this.sector != null;
        }
        return ret;
    }

    public Object sync() {
        return this.sync;
    }

    public M2Sector getSector() {
        return this.sector;
    }

    public M2Key getKey() {
        return this.key;
    }
}

