/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.maachang.dbm.engine.M2HashFlag;
import org.maachang.dbm.engine.MDbmEnv;
import org.maachang.util.ConvertParam;
import org.maachang.util.FileUtil;

public class M2Hash {
    public static final int MAX_HASH_SIZE = MDbmEnv.HASH;
    private static final int FLAG_POS_OFFSET = M2HashFlag.convertRect(MDbmEnv.HASH);
    public static final int MASK_HASH = MAX_HASH_SIZE - 1;
    public static final int MAX_SEQUENCE_ID = 64;
    public static final int ONE_HASH = 8;
    private RandomAccessFile fp = null;
    private MappedByteBuffer map = null;
    private String filename = null;
    private int size = -1;
    private M2HashFlag posMan = null;
    private final byte[] tmp = new byte[8];
    private final byte[] tmpSize = new byte[4];
    private static final int SEQUENCE_OFFSET = FLAG_POS_OFFSET + MAX_HASH_SIZE * 8;
    private static final int DATA_SIZE_OFFSET = FLAG_POS_OFFSET + MAX_HASH_SIZE * 8 + 512;

    private M2Hash() {
    }

    public M2Hash(String filename) throws Exception {
        if (filename == null || (filename = filename.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        filename = FileUtil.getFullPath((String)filename);
        boolean isFile = FileUtil.isFileExists((String)filename);
        RandomAccessFile fp = new RandomAccessFile(filename, "rwd");
        if (!isFile) {
            M2Hash.initFile(fp);
        }
        FileChannel channel = fp.getChannel();
        MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_WRITE, 0L, fp.length());
        M2HashFlag pflg = new M2HashFlag(map, MAX_HASH_SIZE);
        this.fp = fp;
        this.map = map;
        this.filename = filename;
        this.posMan = pflg;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.map != null) {
            try {
                this.map.force();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fp != null) {
            try {
                this.fp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fp = null;
        this.map = null;
        this.filename = null;
        this.posMan = null;
    }

    public synchronized void flush() throws Exception {
        if (this.map != null) {
            this.map.force();
        }
    }

    public synchronized void put(int hash, int pos, int fileNo) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (hash <= -1 || hash >= MAX_HASH_SIZE) {
            throw new IllegalArgumentException("\u6307\u5b9aHash\u30b3\u30fc\u30c9(" + hash + ")\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        this.map.position(FLAG_POS_OFFSET + hash * 8);
        ConvertParam.convertInt((byte[])this.tmp, (int)0, (int)pos);
        ConvertParam.convertInt((byte[])this.tmp, (int)4, (int)fileNo);
        this.map.put(this.tmp);
        if (pos == -1 || fileNo == -1) {
            this.posMan.removePos(hash);
        } else {
            this.posMan.setPos(hash);
        }
    }

    public synchronized void remove(int hash) throws Exception {
        this.put(hash, -1, -1);
    }

    public synchronized long get(int hash) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (hash <= -1 || hash >= MAX_HASH_SIZE) {
            throw new IllegalArgumentException("\u6307\u5b9aHash\u30b3\u30fc\u30c9(" + hash + ")\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        this.map.position(FLAG_POS_OFFSET + hash * 8);
        byte[] b = this.tmp;
        this.map.get(b);
        return ConvertParam.convertLong((int)0, (byte[])b);
    }

    public synchronized int useHash(int pos) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.posMan.useNextPos(pos);
    }

    public synchronized String getFileName() {
        if (!this.check()) {
            return null;
        }
        return this.filename;
    }

    public synchronized long sequenceId(int no) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (no < 0 || no >= 64) {
            return -1L;
        }
        byte[] b = new byte[8];
        int off = SEQUENCE_OFFSET + no * 8;
        this.map.position(off);
        this.map.get(b);
        long ret = ConvertParam.convertLong((int)0, (byte[])b);
        b = null;
        ret = ret >= Long.MAX_VALUE ? 0L : ++ret;
        this.map.position(off);
        this.map.put(ConvertParam.convertLong((long)ret));
        return ret;
    }

    public synchronized void addOne() throws Exception {
        if (this.size <= -1) {
            this.readSize();
        }
        ++this.size;
        this.writeSize();
    }

    public synchronized void deleteOne() throws Exception {
        if (this.size <= -1) {
            this.readSize();
        }
        --this.size;
        if (this.size <= 0) {
            this.size = 0;
        }
        this.writeSize();
    }

    public synchronized int getSize() throws Exception {
        if (this.size <= -1) {
            this.readSize();
        }
        return this.size;
    }

    public synchronized boolean isUse() {
        return this.check();
    }

    private boolean check() {
        return this.fp != null && this.map != null;
    }

    private static final void initFile(RandomAccessFile fp) throws Exception {
        int off = MAX_HASH_SIZE * 8 + FLAG_POS_OFFSET;
        byte[] b = new byte[off + 512 + 4];
        Arrays.fill(b, (byte)-1);
        int i = 0;
        while (i < FLAG_POS_OFFSET) {
            b[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 64) {
            b[off] = 0;
            b[off + 1] = 0;
            b[off + 2] = 0;
            b[off + 3] = 0;
            b[off + 4] = 0;
            b[off + 5] = 0;
            b[off + 6] = 0;
            b[off + 7] = 0;
            off += 8;
            ++i;
        }
        fp.seek(0L);
        fp.write(b);
    }

    private void readSize() throws Exception {
        this.map.position(DATA_SIZE_OFFSET);
        this.map.get(this.tmpSize);
        this.size = ConvertParam.convertInt((int)0, (byte[])this.tmpSize);
        if (this.size <= -1) {
            this.size = 0;
        }
    }

    private void writeSize() throws Exception {
        ConvertParam.convertInt((byte[])this.tmpSize, (int)0, (int)this.size);
        this.map.position(DATA_SIZE_OFFSET);
        this.map.put(this.tmpSize);
    }
}

