/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import org.maachang.dbm.engine.M2Hash;
import org.maachang.dbm.engine.M2KeyChild;
import org.maachang.dbm.engine.M2NextKey;
import org.maachang.dbm.engine.M2Sector;
import org.maachang.dbm.engine.M2SectorData;

public class M2Key {
    private M2Hash hash = null;
    private M2Sector sector = null;

    private M2Key() {
    }

    public M2Key(M2Hash hash, M2Sector sector) {
        this.hash = hash;
        this.sector = sector;
    }

    protected void finalize() throws Exception {
        this.hash = null;
        this.sector = null;
    }

    public void add(int code, byte[] key, int no, int fileNo) throws Exception {
        M2KeyChild ch = new M2KeyChild();
        if (this.search(ch, code, key)) {
            this.sector.removeAll(ch.getElementPos(), ch.getElementFileNo());
            ch.setElementPos(no);
            ch.setElementFileNo(fileNo);
            M2SectorData data = ch.header();
            this.sector.writeOne(data, ch.getStartPos(), ch.getStartFileNo());
        } else if (ch.getStartPos() == -1) {
            ch.clear();
            ch.setElementPos(no);
            ch.setElementFileNo(fileNo);
            ch.setHashCode(code);
            ch.setData(key);
            byte[] b = ch.save();
            ch = null;
            long p = this.sector.writeAll(b, 0, b.length);
            this.hash.put(M2Key.mask(code), (int)(p & 0xFFFFFFFFL), (int)((p & 0xFFFFFFFF00000000L) >> 32));
            this.hash.addOne();
        } else {
            M2KeyChild newCh = new M2KeyChild();
            newCh.setBefPos(ch.getStartPos());
            newCh.setBefFileNo(ch.getStartFileNo());
            newCh.setElementPos(no);
            newCh.setElementFileNo(fileNo);
            newCh.setHashCode(code);
            newCh.setData(key);
            byte[] b = newCh.save();
            newCh = null;
            long p = this.sector.writeAll(b, 0, b.length);
            ch.setNextPos((int)(p & 0xFFFFFFFFL));
            ch.setNextFileNo((int)((p & 0xFFFFFFFF00000000L) >> 32));
            M2SectorData data = ch.header();
            this.sector.writeOne(data, ch.getStartPos(), ch.getStartFileNo());
            this.hash.addOne();
        }
    }

    public void remove(int code, byte[] key) throws Exception {
        M2KeyChild ch = new M2KeyChild();
        if (this.search(ch, code, key)) {
            this.sector.removeAll(ch.getElementPos(), ch.getElementFileNo());
            this.sector.removeAll(ch.getStartPos(), ch.getStartFileNo());
            this.hash.deleteOne();
            int befPos = ch.getBefPos();
            int befFileNo = ch.getBefFileNo();
            int nextPos = ch.getNextPos();
            int nextFileNo = ch.getNextFileNo();
            if (nextPos <= -1 || nextFileNo <= -1) {
                nextPos = -1;
                nextFileNo = -1;
            }
            if (befPos <= -1 || befFileNo <= -1) {
                befPos = -1;
                befFileNo = -1;
            }
            if (nextPos <= -1 && nextFileNo <= -1 && befPos <= -1 && befFileNo <= -1) {
                this.hash.remove(M2Key.mask(code));
            } else {
                M2SectorData data;
                if (befPos >= 0 && befFileNo >= 0) {
                    data = new M2SectorData();
                    this.sector.readOne(data, befPos, befFileNo);
                    ch.create(data, befPos, befFileNo);
                    ch.setNextPos(nextPos);
                    ch.setNextFileNo(nextFileNo);
                    ch.header(data);
                    this.sector.writeOne(data, befPos, befFileNo);
                }
                if (nextPos >= 0 && nextFileNo >= 0) {
                    data = new M2SectorData();
                    this.sector.readOne(data, nextPos, nextFileNo);
                    ch.create(data, nextPos, nextPos);
                    ch.setBefPos(befPos);
                    ch.setBefFileNo(befFileNo);
                    ch.header(data);
                    this.sector.writeOne(data, nextPos, nextFileNo);
                    if (befPos <= -1 || befFileNo <= -1) {
                        this.hash.put(M2Key.mask(code), nextPos, nextFileNo);
                    }
                }
            }
        }
    }

    public long get(int code, byte[] key) throws Exception {
        M2KeyChild ch = new M2KeyChild();
        if (this.search(ch, code, key)) {
            return (long)ch.getElementPos() & 0xFFFFFFFFL | ((long)ch.getElementFileNo() & 0xFFFFFFFFL) << 32;
        }
        return -1L;
    }

    public M2NextKey nextKey(M2NextKey next) throws Exception {
        if (next == null) {
            next = new M2NextKey();
        }
        if (next.getCount() >= this.hash.getSize()) {
            return null;
        }
        boolean result = false;
        int pos = -1;
        int fno = -1;
        while (true) {
            if (next.getPos() <= -1 && next.getFileNo() <= 0) {
                int code = this.hash.useHash(next.getHashNo());
                if (code <= -1) {
                    return null;
                }
                next.setHashNo(code);
                long pf = this.hash.get(code);
                if (pf <= -1L) continue;
                pos = (int)(pf & 0xFFFFFFFFL);
                fno = (int)((pf & 0xFFFFFFFF00000000L) >> 32);
                result = true;
            } else {
                pos = next.getPos();
                fno = next.getFileNo();
                result = true;
            }
            if (result) break;
        }
        byte[] b = this.sector.readAll(pos, fno);
        M2KeyChild ch = new M2KeyChild(b, pos, fno, -1, -1);
        next.setPos(ch.getNextPos());
        next.setFileNo(ch.getNextFileNo());
        next.setKey(ch.getData());
        next.addCount();
        return next;
    }

    public int size() throws Exception {
        return this.hash.getSize();
    }

    public M2Hash getHash() {
        return this.hash;
    }

    private boolean search(M2KeyChild ch, int code, byte[] key) throws Exception {
        ch.clear();
        int hcd = M2Key.mask(code);
        long startPos = this.hash.get(hcd);
        if (startPos <= -1L) {
            return false;
        }
        int pos = (int)(startPos & 0xFFFFFFFFL);
        int fno = (int)((startPos & 0xFFFFFFFF00000000L) >> 32);
        M2SectorData data = new M2SectorData();
        while (pos > -1 && fno > -1) {
            this.sector.readOne(data, pos, fno);
            if (data.getLength() <= -1) {
                return false;
            }
            if (this.useChild(ch, data, pos, fno, code, key)) {
                return true;
            }
            pos = ch.getNextPos();
            fno = ch.getNextFileNo();
        }
        return false;
    }

    private boolean useChild(M2KeyChild ch, M2SectorData data, int pos, int fno, int code, byte[] key) throws Exception {
        ch.create(data, pos, fno);
        if (ch.getHashCode() != code && ch.getLength() != key.length) {
            return false;
        }
        while (data.getNextNo() > -1 && data.getNextFileNo() > -1) {
            this.sector.readOne(data, data.getNextNo(), data.getNextFileNo());
            ch.addData(data);
        }
        int len = key.length;
        byte[] b = ch.getData();
        int i = 0;
        while (i < len) {
            if (key[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static final int mask(int code) {
        return code & M2Hash.MASK_HASH;
    }
}

