/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import org.maachang.dbm.engine.M2Buffers;
import org.maachang.dbm.engine.M2OneFileSector;
import org.maachang.dbm.engine.M2SectorData;
import org.maachang.dbm.engine.M2SectorHeader;
import org.maachang.dbm.engine.M2SectorList;
import org.maachang.dbm.engine.M2Write;
import org.maachang.dbm.engine.MDbmEnv;
import org.maachang.util.ArrayBinary;
import org.maachang.util.FileUtil;

public class M2Sector {
    public static final int SECTOR_LENGTH = MDbmEnv.ONE_SECTOR_BY_SECTOR_SIZE;
    public static final int ASYNC_WRITE_SIZE = MDbmEnv.ASYNC_WRITE_SIZE;
    private static final int ONE_SECTOR = MDbmEnv.SECTOR;
    private static final long SECTOR_OFFSET = 12L;
    private static final int BUFFERS_SIZE = MDbmEnv.BUFFERS_SIZE;
    private M2SectorList manager = null;
    private M2Write asyncWrite = null;
    private String dir = null;
    private M2Buffers readBuf = null;
    private M2Buffers writeBuf = null;
    private final Object syncWrite = new Object();

    private M2Sector() {
    }

    public M2Sector(String dir) throws Exception {
        if (dir == null || (dir = dir.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!FileUtil.isDirExists((String)dir)) {
            throw new IOException("\u6307\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea(" + dir + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        M2Buffers rdBuf = new M2Buffers((int)((long)ONE_SECTOR + 12L), BUFFERS_SIZE);
        M2Buffers wtBuf = new M2Buffers((int)((long)ONE_SECTOR + 12L), BUFFERS_SIZE);
        this.dir = dir;
        this.manager = M2Sector.load(dir, this.syncWrite, rdBuf, wtBuf);
        this.asyncWrite = new M2Write(ASYNC_WRITE_SIZE);
        this.readBuf = rdBuf;
        this.writeBuf = wtBuf;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.asyncWrite != null) {
            this.asyncWrite.destroy();
        }
        if (this.manager != null) {
            this.manager.destroy();
        }
        if (this.readBuf != null) {
            this.readBuf.destroy();
        }
        if (this.writeBuf != null) {
            this.writeBuf.destroy();
        }
        this.manager = null;
        this.asyncWrite = null;
        this.dir = null;
        this.readBuf = null;
        this.writeBuf = null;
    }

    public void readOne(M2SectorData out, int no, int fileNo) throws Exception {
        out.clear();
        if (this.manager.size() <= 0) {
            return;
        }
        byte[] tmp = new byte[ONE_SECTOR];
        M2OneFileSector one = this.manager.get(fileNo);
        if (one == null) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30ebNo(" + fileNo + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        one.read(out, tmp, no);
        if (out.getLength() <= -1) {
            out.clear();
            return;
        }
        out.setData(tmp);
    }

    public byte[] readAll(int no, int fileNo) throws Exception {
        if (this.manager.size() <= 0) {
            return null;
        }
        byte[] tmp = new byte[ONE_SECTOR];
        M2SectorHeader header = new M2SectorHeader();
        ArrayBinary buf = new ArrayBinary(ONE_SECTOR * 2);
        while (no > -1 && fileNo > -1) {
            M2OneFileSector one = this.manager.get(fileNo);
            if (one == null) {
                throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30ebNo(" + fileNo + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            one.read(header, tmp, no);
            if (header.getLength() <= -1) break;
            buf.write(tmp, header.getLength());
            no = header.getNextNo();
            fileNo = header.getNextFileNo();
        }
        if (buf.length() <= 0) {
            return null;
        }
        return buf.getBinary();
    }

    public void writeOne(M2SectorData data, int no, int fileNo) throws Exception {
        M2OneFileSector one;
        if (data.getLength() <= 0) {
            return;
        }
        if (data.getNextNo() <= -1 || data.getNextFileNo() <= -1) {
            data.setNextNo(-1);
            data.setNextFileNo(-1);
        }
        if ((one = this.manager.get(fileNo)) == null) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30ebNo(" + fileNo + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.asyncWrite.write(one, data, data.getData(), no);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long writeAll(byte[] binary, int offset, int length) throws Exception {
        if (offset <= 0) {
            offset = 0;
            if (length <= 0) {
                length = binary.length;
            }
        } else if (length <= 0) {
            length = binary.length - offset;
        }
        M2SectorHeader header = new M2SectorHeader();
        long ret = -1L;
        int addLen = 0;
        int p = -1;
        M2OneFileSector one = null;
        int cnt = 0;
        while (true) {
            int pp;
            M2OneFileSector next;
            M2Sector m2Sector;
            int len;
            int n = len = length >= ONE_SECTOR + addLen ? ONE_SECTOR : length - addLen;
            if (cnt == 0) {
                M2Sector m2Sector2 = this;
                synchronized (m2Sector2) {
                    one = this.getFileSector(one);
                    p = one.getPos();
                }
                ret = (long)p & 0xFFFFFFFFL | ((long)one.getFileNo() & 0xFFFFFFFFL) << 32;
                if (len >= length) {
                    header.setNextNo(-1);
                    header.setNextFileNo(-1);
                    header.setLength(len);
                    this.asyncWrite.write(one, header, binary, p, offset);
                    break;
                }
                m2Sector = this;
                synchronized (m2Sector) {
                    next = this.getFileSector(one);
                    pp = next.getPos();
                }
                header.setNextNo(pp);
                header.setNextFileNo(next.getFileNo());
                header.setLength(len);
                this.asyncWrite.write(one, header, binary, p, offset);
                addLen += len;
                one = next;
                p = pp;
            } else {
                if (len + addLen >= length) {
                    header.setNextNo(-1);
                    header.setNextFileNo(-1);
                    header.setLength(len);
                    this.asyncWrite.write(one, header, binary, p, addLen + offset);
                    break;
                }
                m2Sector = this;
                synchronized (m2Sector) {
                    next = this.getFileSector(one);
                    pp = next.getPos();
                }
                header.setNextNo(pp);
                header.setNextFileNo(next.getFileNo());
                header.setLength(len);
                this.asyncWrite.write(one, header, binary, p, addLen + offset);
                addLen += len;
                one = next;
                p = pp;
            }
            ++cnt;
        }
        return ret;
    }

    public void removeAll(int no, int fileNo) throws Exception {
        if (this.manager.size() <= 0) {
            return;
        }
        byte[] tmp = new byte[ONE_SECTOR];
        M2SectorHeader header = new M2SectorHeader();
        while (true) {
            M2OneFileSector one;
            if ((one = this.manager.get(fileNo)) == null) {
                throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30ebNo(" + fileNo + ")\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            }
            one.read(header, tmp, no);
            one.removePos(no);
            if (header.getNextNo() <= -1 || header.getNextFileNo() <= -1) break;
            no = header.getNextNo();
            fileNo = header.getNextFileNo();
        }
    }

    public synchronized int getSize() {
        return this.manager.size();
    }

    private static final M2SectorList load(String dir, Object syncWrite, M2Buffers readBuf, M2Buffers writeBuf) throws Exception {
        String[] lst = FileUtil.getFileList((String)dir);
        int len = lst.length;
        M2SectorList ret = new M2SectorList();
        int i = 0;
        while (i < len) {
            if (lst[i] != null && lst[i].endsWith(".sct2")) {
                int fileNo = -1;
                try {
                    fileNo = Integer.parseInt(lst[i].substring(0, lst[i].length() - ".sct2".length()).trim());
                }
                catch (Exception e) {
                    fileNo = -1;
                }
                if (fileNo != -1) {
                    M2OneFileSector one = new M2OneFileSector(fileNo, dir, SECTOR_LENGTH, syncWrite, readBuf, writeBuf);
                    ret.put(fileNo, one);
                }
            }
            ++i;
        }
        return ret;
    }

    private synchronized M2OneFileSector getFileSector(M2OneFileSector o) throws Exception {
        if (o == null || o.getMax() <= o.getSize()) {
            o = this.getUseFileSector();
            if (o == null) {
                o = this.newUseFileSector();
            }
        } else {
            o = this.getUseFileSector();
        }
        return o;
    }

    private M2OneFileSector getUseFileSector() throws Exception {
        int len = this.manager.size();
        int i = 1;
        while (i < len) {
            M2OneFileSector m = this.manager.get(i);
            if (m != null && m.getMax() > m.getSize()) {
                return m;
            }
            ++i;
        }
        return null;
    }

    private M2OneFileSector newUseFileSector() throws Exception {
        int no = this.manager.size() + 1;
        while (this.manager.get(no) != null) {
            ++no;
        }
        M2OneFileSector one = new M2OneFileSector(no, this.dir, SECTOR_LENGTH, this.syncWrite, this.readBuf, this.writeBuf);
        this.manager.put(no, one);
        return one;
    }
}

