/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import org.maachang.dbm.engine.M2OneFileSector;
import org.maachang.dbm.engine.M2SectorHeader;
import org.maachang.dbm.engine.M2WriteElement;
import org.maachang.dbm.engine.M2WriteQueue;
import org.maachang.dbm.engine.M2WriteThread;

class M2Write {
    private static final int MIN = 3;
    private static final int MAX = 50;
    private M2WriteQueue queue = null;
    private M2WriteThread[] threads = null;

    private M2Write() {
    }

    public M2Write(int size) throws Exception {
        if (size <= 3) {
            size = 3;
        } else if (size >= 50) {
            size = 50;
        }
        M2WriteQueue q = new M2WriteQueue();
        M2WriteThread[] t = new M2WriteThread[size];
        int i = 0;
        while (i < size) {
            t[i] = new M2WriteThread(q);
            ++i;
        }
        this.queue = q;
        this.threads = t;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.threads != null) {
            if (this.queue != null) {
                while (this.queue.elementSize() > 0) {
                    try {
                        Thread.sleep(30L);
                    }
                    catch (Exception exception) {}
                }
            }
            int len = this.threads.length;
            int i = 0;
            while (i < len) {
                if (this.threads[i] != null) {
                    this.threads[i].destroy();
                }
                this.threads[i] = null;
                ++i;
            }
        }
        this.threads = null;
        this.queue = null;
    }

    public void write(M2OneFileSector sectorObject, M2SectorHeader header, byte[] data, int no) throws Exception {
        this.write(sectorObject, header, data, no, 0);
    }

    public void write(M2OneFileSector sectorObject, M2SectorHeader header, byte[] data, int no, int offset) throws Exception {
        if (this.isUse() && sectorObject != null && header != null) {
            if (sectorObject.syncWrite(true, no)) {
                sectorObject.onSync(no);
                M2SectorHeader insert = new M2SectorHeader();
                header.copyObject(insert);
                byte[] insertData = new byte[insert.getLength()];
                System.arraycopy(data, offset, insertData, 0, insert.getLength());
                this.queue.append(new M2WriteElement(sectorObject, insert, insertData, no, 0));
            } else {
                sectorObject.writeTo(false, header, data, no, offset);
            }
        }
    }

    private synchronized boolean isUse() {
        return this.queue != null;
    }
}

