/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.dbm.engine.M2WriteElement;
import org.maachang.dbm.engine.M2WriteQueue;
import org.maachang.dbm.engine.MDbmDefine;
import org.maachang.util.thread.LoopThread;

class M2WriteThread
extends LoopThread {
    private static final Log logOut = LogFactory.getLog(M2WriteThread.class);
    private M2WriteQueue queue = null;

    private M2WriteThread() {
    }

    public M2WriteThread(M2WriteQueue queue) throws Exception {
        this.queue = queue;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        this.queue = null;
    }

    protected boolean execution() throws Exception {
        boolean writeFlag = false;
        M2WriteElement element = this.queue.getQueue();
        try {
            if (element == null) {
                Thread.sleep(1L);
                return true;
            }
            writeFlag = true;
            element.getSectorObject().writeTo(true, element.getHeader(), element.getData(), element.getNo(), element.getOffset());
            return true;
        }
        catch (Exception e) {
            if (MDbmDefine.OUT_MODE) {
                logOut.error((Object)("## error - fileNo:" + element.getSectorObject().getFileNo() + " pos:" + element.getNo() + " offset:" + element.getOffset() + " length:" + element.getHeader().getLength() + " dataLength:" + (element.getData() == null ? "0" : Integer.valueOf(element.getData().length))), (Throwable)e);
            }
            throw e;
        }
        {
            finally {
                if (writeFlag) {
                    try {
                        this.queue.relaseElement();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

