/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;

class PoolConnection {
    private Connection connection = null;
    private String chkSQL = null;
    private boolean useFlag = false;
    private long active = -1L;
    private long lastAccess = -1L;
    private boolean commitRollbackFlag = false;
    private boolean closeByCommitFlag = false;
    private Object sync = new Object();

    protected PoolConnection() {
    }

    protected final void finalize() throws Exception {
        try {
            this.destroyObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void createObject(Connection connection, boolean closeByCommit) throws Exception {
        this.createObject(connection, null, closeByCommit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createObject(Connection connection, String sql, boolean closeByCommit) throws Exception {
        if (connection == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            if (connection.isClosed()) {
                throw new IllegalArgumentException("\u6307\u5b9a\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u306f\u3001\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            this.destroyObject();
            Object object = this.sync;
            synchronized (object) {
                this.connection = connection;
                this.chkSQL = sql == null || (sql = sql.trim()).length() <= 0 ? null : sql;
                this.useFlag = false;
                this.active = -1L;
                this.lastAccess = System.currentTimeMillis();
                this.commitRollbackFlag = false;
                this.closeByCommitFlag = closeByCommit;
            }
        }
        catch (IllegalArgumentException in) {
            this.destroyObject();
            throw in;
        }
        catch (Exception e) {
            this.destroyObject();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyObject() {
        try {
            Object object = this.sync;
            synchronized (object) {
                try {
                    if (this.connection != null) {
                        this.connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.connection = null;
                this.chkSQL = null;
                this.useFlag = false;
                this.active = -1L;
                this.lastAccess = System.currentTimeMillis();
                this.commitRollbackFlag = false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.connection = null;
        this.chkSQL = null;
        this.useFlag = false;
        this.active = -1L;
        this.commitRollbackFlag = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        boolean ret = false;
        try {
            Object object = this.sync;
            synchronized (object) {
                if (this.connection != null && !this.useFlag && !this.isCuttingConnection()) {
                    this.useFlag = true;
                    this.active = System.currentTimeMillis();
                    this.lastAccess = System.currentTimeMillis();
                    this.commitRollbackFlag = false;
                    ret = true;
                }
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            Object object = this.sync;
            synchronized (object) {
                if (this.connection != null && !this.commitRollbackFlag && this.useFlag) {
                    if (this.closeByCommitFlag) {
                        try {
                            this.connection.commit();
                        }
                        catch (SQLException sse) {
                            this.destroyObject();
                            throw sse;
                        }
                    }
                    try {
                        this.connection.rollback();
                    }
                    catch (SQLException sse) {
                        this.destroyObject();
                        throw sse;
                    }
                }
                if (this.connection != null) {
                    try {
                        this.connection.clearWarnings();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.useFlag = false;
                this.commitRollbackFlag = false;
                this.active = -1L;
                this.lastAccess = System.currentTimeMillis();
            }
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActiveTime() {
        long ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.active;
            }
        }
        catch (Exception e) {
            ret = -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastAccessTime() {
        long ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.lastAccess;
            }
        }
        catch (Exception e) {
            ret = -1L;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCheckSQL() {
        String ret = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.chkSQL;
            }
        }
        catch (Exception e) {
            ret = null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedByIf() {
        boolean ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.closeByCommitFlag;
            }
        }
        catch (Exception e) {
            ret = this.closeByCommitFlag;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCommitRoolback() {
        boolean ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.commitRollbackFlag;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret;
        try {
            Object object = this.sync;
            synchronized (object) {
                ret = this.useFlag;
            }
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Connection getConnection() throws SQLException {
        Connection ret = null;
        try {
            Object object = this.sync;
            synchronized (object) {
                this.checkOpen();
                this.lastAccess = System.currentTimeMillis();
                ret = this.connection;
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isCuttingConnection() {
        Statement tmp = null;
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            try {
                try {
                    ret = this.connection.isClosed();
                    tmp = this.connection.createStatement();
                    if (this.chkSQL != null) {
                        tmp.execute(this.chkSQL);
                    }
                }
                catch (Exception e) {
                    ret = true;
                }
            }
            finally {
                try {
                    tmp.close();
                }
                catch (Exception exception) {}
                tmp = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void checkOpen() throws SQLException {
        try {
            Object object = this.sync;
            synchronized (object) {
                if (!this.useFlag) {
                    throw new SQLException("\u30aa\u30fc\u30d7\u30f3\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                }
            }
        }
        catch (SQLException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SQLException("\u30aa\u30fc\u30d7\u30f3\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void commitRollbackON() {
        try {
            Object object = this.sync;
            synchronized (object) {
                this.commitRollbackFlag = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected final Object getSync() {
        return this.sync;
    }
}

