// MaachangComet開始用スクリプト.
//

// スタートアップパラメータを取得.
getStartupParams = function() {
    if( isNull( _$startup$params ) == false ) {
        return _$startup$params ;
    }
    return null ;
}

// スタートアップパラメータを、キー指定で取得.
getStartupParam = function(name) {
    if( isNull( name ) ) {
        return null ;
    }
    if( isNull( _$startup$params ) == false ) {
        return parseValue( _$startup$params.get( name ) ) ;
    }
    return null ;
}

// スタートアップ処理用パラメータ定義.
putStartupParam = function( name,value ) {
    if( isNull( name ) || isNull( value ) ) {
        return ;
    }
    //if( isNull( _$startup$params ) == false && getScriptDetail() == "startup" ) {
    if( isNull( _$startup$params ) == false ) {
        _$startup$params.put( name,value ) ;
    }
} ;

// スタートアップ処理用パラメータ削除.
removeStartupParam = function( name ) {
    if( isNull( name ) ) {
        return ;
    }
    //if( isNull( _$startup$params ) == false && getScriptDetail() == "startup" ) {
    if( isNull( _$startup$params ) == false ) {
        _$startup$params.remove( name ) ;
    }
} ;

// スタートアップパラメータ.
startupParams = function() {
    return new JSAdapter({
        __get__ : function(name) {
            if( isNull( _$startup$params ) == false ) {
                var ret = _$startup$params.get( name ) ;
                return parseValue( ret ) ;
            }
            return null ;
        },
        __has__ :  function(name) {
            if( isNull( _$startup$params ) == false ) {
                return _$startup$params.get( name ) != null ;
            }
            return false ;
        },
        __delete__ : function (name) {
            return null
        },
        __put__ : function(name, value) {
            return null ;
        },
        __getIds__ : function() {
            return null ;
        }
    });
} ;

// DBキャッシュ情報を取得.
getCacheDB = function( name ) {
    return getStartupParam( name ) ;
}

// DBキャッシュ処理.
cacheDB = function( name ) {
    if( useString( name ) == false ) {
        return false ;
    }
    var bindings = bindings() ;
    var model = bindings.get( name ) ;
    if( isNull( model ) ) {
        return false ;
    }
    putStartupParam( name,model.find( null,null,"id" ) ) ;
    return true ;
}

// DBキャッシュを破棄.
releaseCacheDB = function( name ) {
    if( useString( name ) == false ) {
        return false ;
    }
    removeStartupParam( name ) ;
    return true ;
}

///////////////////////////////////////////////////////////////////////////////
// スタートアップパラメータ展開.
///////////////////////////////////////////////////////////////////////////////
starts = startupParams() ;

