package org.maachang.comet.httpd.engine.script.service.client;

/**
 * Http結果情報.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class HttpResult {
    
    /**
     * バイナリ情報.
     */
    private byte[] binary = null ;
    
    /**
     * ContentType
     */
    private String contentType = null ;
    
    /**
     * レスポンスステータス.
     */
    private int state = 0 ;
    
    /**
     * コンストラクタ.
     */
    public HttpResult() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR>
     * @param binary 対象のバイナリを設定します.
     * @param state 対象のステータスを設定します.
     * @param contentType 対象のContentTypeを設定します.
     */
    public HttpResult( byte[] binary,int state,String contentType ) {
        this.state = state ;
        this.binary = binary ;
        this.contentType = contentType ;
        
    }
    
    /**
     * binary を取得.
     * <BR><BR>
     * @return binary が返されます.
     */
    public byte[] getBinary() {
        return binary;
    }
    
    /**
     * binary を設定.
     * <BR><BR>
     * @param binary binary を設定します.
     */
    public void setBinary(byte[] binary) {
        this.binary = binary;
    }
    
    /**
     * contentType を取得.
     * <BR><BR>
     * @return contentType が返されます.
     */
    public String getContentType() {
        return contentType;
    }
    
    /**
     * contentType を設定.
     * <BR><BR>
     * @param contentType contentType を設定します.
     */
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }
    
    /**
     * state を取得.
     * <BR><BR>
     * @return state が返されます.
     */
    public int getState() {
        return state;
    }
    
    /**
     * state を設定.
     * <BR><BR>
     * @param state state を設定します.
     */
    public void setState(int state) {
        this.state = state;
    }
}
