package org.maachang.comet.net.nio ;


/**
 * KeepAlive情報を管理.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
public class KeepAliveFactory {
    
    /**
     * デフォルトKeepAlive時間.
     */
    private static final int DEF_TIME = 3 ;
    
    /**
     * デフォルトKeepAliveカウント.
     */
    private static final int DEF_COUNT = 100 ;
    
    /**
     * シングルトン.
     */
    private static final KeepAliveFactory SNGL = new KeepAliveFactory() ;
    
    /**
     * KeepAlive管理時間.
     */
    private KeepAliveBean base = null ;
    
    /**
     * オブジェクトを取得.
     * @return KeepAliveFactory オブジェクトが返されます.
     */
    public static final KeepAliveFactory getInstance() {
        return SNGL ;
    }
    
    /**
     * コンストラクタ.
     */
    private KeepAliveFactory() {
        base = new KeepAliveBean() ;
        base.setTime( DEF_TIME ) ;
        base.setCount( DEF_COUNT ) ;
    }
    
    /**
     * KeepAlive値を設定.
     * @param time 対象の時間を設定します.
     * @param count 対象のカウントを設定します.
     */
    public synchronized void set( int time,int count ) {
        base.setTime( time ) ;
        base.setCount( count ) ;
    }
    
    /**
     * 新しいKeepAlive値を取得.
     * @return KeepAliveBean 新しいKeepAliveBeanが返されます.
     */
    public synchronized KeepAliveBean getBean() {
        KeepAliveBean ret = new KeepAliveBean() ;
        ret.setTime( base.getTime() ) ;
        ret.setCount( base.getCount() ) ;
        return ret ;
    }
}
