/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio;

import java.io.File;
import java.io.IOException;
import org.maachang.rawio.NativeRawIO;
import org.maachang.rawio.Rawio;

class DirectIOImpl
implements Rawio {
    private long fp = -1L;
    private int sector = -1;
    private String name = null;
    private long flen = -1L;
    private int sectorToFileLength = -1;
    private volatile boolean isOpenFlag = false;
    private final Object readSync = new Object();
    private final Object writeSync = new Object();

    private DirectIOImpl() {
    }

    public DirectIOImpl(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        name = new File(name).getCanonicalPath();
        String path = DirectIOImpl.getPath(name);
        long fp = NativeRawIO.rawOpen(name.getBytes());
        if (fp == -1L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + name + "]");
        }
        int sector = NativeRawIO.getSector(path.getBytes());
        if (sector <= -1) {
            sector = NativeRawIO.getSectorByHandle(fp);
        }
        this.flen = NativeRawIO.getRawLength(fp);
        this.fp = fp;
        this.sector = sector;
        this.name = name;
        this.sectorToFileLength = (int)(this.flen / (long)this.sector);
        this.isOpenFlag = true;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this.isOpen()) {
            DirectIOImpl directIOImpl = this;
            synchronized (directIOImpl) {
                this.isOpenFlag = false;
            }
            try {
                NativeRawIO.rawClose(this.fp);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fp = -1L;
        this.sector = -1;
        this.name = null;
        this.flen = -1L;
        this.sectorToFileLength = -1;
    }

    public void flush() throws Exception {
    }

    public void expansion(int size) throws Exception {
        if (!this.isOpen()) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u9589\u3058\u3066\u3044\u307e\u3059");
        }
        if (size <= 0) {
            return;
        }
        int len = this.length() + size;
        this.setLength(len);
    }

    public int getSector() {
        if (this.isOpen()) {
            return this.sector;
        }
        return -1;
    }

    public String getName() {
        if (this.isOpen()) {
            return this.name;
        }
        return null;
    }

    public int length() {
        if (this.isOpen()) {
            return this.sectorToFileLength;
        }
        return -1;
    }

    public void setLength(int size) throws Exception {
        long fileLan;
        if (this.isOpen()) {
            if (size <= -1) {
                size = 0;
            }
            if (NativeRawIO.setRawLength(this.fp, fileLan = (long)this.sector * (long)size) <= -1) {
                throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u306e\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f[" + size + "]");
            }
        } else {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u9589\u3058\u3066\u3044\u307e\u3059");
        }
        this.flen = fileLan;
        this.sectorToFileLength = size;
    }

    public byte[] read(int no) throws Exception {
        byte[] ret = new byte[this.sector];
        this.read(ret, no);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(byte[] out, int no) throws Exception {
        int ret;
        if (!this.isOpen()) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u9589\u3058\u3066\u3044\u307e\u3059");
        }
        if (out == null || out.length != this.sector) {
            throw new IllegalArgumentException("\u8aad\u307f\u8fbc\u307f\u5bfe\u8c61\u30d0\u30a4\u30ca\u30ea\u9577\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (no <= -1 || no >= this.sectorToFileLength) {
            throw new IllegalArgumentException("\u6307\u5b9a\u9805\u756a[" + no + "]\u306f\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u5916\u3067\u3059");
        }
        Object object = this.readSync;
        synchronized (object) {
            ret = NativeRawIO.rawRead(this.fp, this.sector, no, out);
        }
        if (ret <= -1) {
            throw new IOException("\u6307\u5b9a\u9805\u756a[" + no + "]\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public void write(byte[] in, int no) throws Exception {
        this.write(false, in, no);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(boolean mode, byte[] in, int no) throws Exception {
        int ret;
        if (!this.isOpen()) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u9589\u3058\u3066\u3044\u307e\u3059");
        }
        if (in == null) {
            throw new IllegalArgumentException("\u8aad\u307f\u8fbc\u307f\u5bfe\u8c61\u30d0\u30a4\u30ca\u30ea\u9577\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (no <= -1 || no >= this.sectorToFileLength) {
            throw new IllegalArgumentException("\u6307\u5b9a\u9805\u756a[" + no + "]\u306f\u30d5\u30a1\u30a4\u30eb\u30b5\u30a4\u30ba\u5916\u3067\u3059");
        }
        byte[] b = null;
        if (in.length != this.sector) {
            if (mode) {
                throw new IOException("\u66f8\u8fbc\u307f\u30d0\u30a4\u30ca\u30ea\u9577\u306f\u4e0d\u6b63\u3067\u3059");
            }
            int len = in.length;
            if (len > this.sector) {
                len = this.sector;
            }
            b = new byte[this.sector];
            System.arraycopy(in, 0, b, 0, len);
        } else {
            b = in;
        }
        Object object = this.writeSync;
        synchronized (object) {
            ret = NativeRawIO.rawWrite(this.fp, this.sector, no, b);
        }
        if (ret <= -1) {
            throw new IOException("\u6307\u5b9a\u9805\u756a[" + no + "]\u306e\u66f8\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public int getType() {
        return 0;
    }

    protected static final String getPath(String name) throws Exception {
        String path = name = new File(name).getCanonicalPath();
        int p = path.indexOf(System.getProperty("file.separator"));
        if (p != -1) {
            path = String.valueOf(path.substring(0, p)) + System.getProperty("file.separator");
        }
        return path;
    }

    private synchronized boolean isOpen() {
        return this.isOpenFlag;
    }
}

