/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio.async;

import org.maachang.rawio.Rawio;
import org.maachang.rawio.async.ASyncElement;
import org.maachang.rawio.async.ASyncQueue;
import org.maachang.rawio.async.ASyncWriteLock;
import org.maachang.rawio.async.AbstractLoopThread;

class ASyncWriteThread
extends AbstractLoopThread {
    private ASyncQueue queue = null;

    private ASyncWriteThread() {
    }

    public ASyncWriteThread(ASyncQueue queue) throws Exception {
        this.queue = queue;
        this.startThread();
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        super.stopThread();
    }

    protected void clear() {
        this.queue = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean execution() throws Exception {
        boolean writeFlag = false;
        ASyncElement element = this.queue.getQueue();
        if (element == null) {
            Thread.sleep(1L);
            return true;
        }
        int no = -1;
        ASyncWriteLock lock = null;
        try {
            lock = element.getLock();
            no = element.getNo();
            if (lock == null) return true;
            if (!lock.flag(no)) return true;
            writeFlag = true;
            Rawio raw = element.getRaw();
            try {
                raw.write(element.getData(), no);
                return true;
            }
            finally {
                lock.off(no);
            }
        }
        catch (Exception e) {
            writeFlag = true;
            throw e;
        }
        finally {
            if (writeFlag) {
                try {
                    this.queue.relaseElement();
                }
                catch (Exception exception) {}
            }
        }
    }
}

