/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rawio.mapping;

import java.io.IOException;
import java.util.Iterator;
import org.maachang.rawio.Baseio;
import org.maachang.rawio.mapping.MappingChild;
import org.maachang.rawio.mapping.MappingManager;
import org.maachang.rawio.mapping.MappingOp;
import org.maachang.rawio.mapping.MappingOpImpl;
import org.maachang.rawio.mapping.Mappingio;

class MappingioImpl
implements Mappingio {
    private static final int UPDATE_BY_FLUSH_LENGTH = 32;
    private Baseio baseio = null;
    private int sectorSize = -1;
    private MappingManager manager = null;
    private final Object sync = new Object();

    private MappingioImpl() {
    }

    public MappingioImpl(Baseio io) throws Exception {
        if (io == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.baseio = io;
        this.sectorSize = io.getSector();
        this.manager = new MappingManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.manager != null) {
                this.manager.destroy();
            }
            this.baseio = null;
            this.sectorSize = -1;
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            int len = this.manager.length();
            int i = 0;
            while (i < len) {
                MappingChild ch = this.manager.getArray(i);
                if (ch.updateLength() > 0) {
                    int startPos = ch.getStartPos();
                    Iterator<Integer> it = ch.iterator();
                    while (it.hasNext()) {
                        int n;
                        byte[] b;
                        Integer no = it.next();
                        it.remove();
                        if (no == null || (b = ch.get(n = no.intValue())) == null) continue;
                        try {
                            this.baseio.write(b, startPos + n);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MappingOp addMapping(int start, int length) throws Exception {
        MappingOpImpl ret = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (start < 0 || length <= 0 || start + length > this.baseio.length()) {
                throw new IllegalArgumentException("\u6307\u5b9a\u7bc4\u56f2(start:" + start + " length:" + length + ")\u306f\u4e0d\u6b63\u3067\u3059");
            }
            MappingChild ch = this.manager.add(this.sectorSize, start, length);
            int pos = start;
            int i = 0;
            while (i < length) {
                byte[] b = ch.get(i);
                this.baseio.read(b, pos);
                ++pos;
                ++i;
            }
            ret = new MappingOpImpl(this, ch, this.sync);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMapping(int no) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            return this.manager.isMapping(no);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int mappingSize() throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            return this.manager.mappingSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Baseio getBaseio() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                return null;
            }
            return this.baseio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expansion(int size) throws Exception {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (size <= 0) {
                return;
            }
            this.baseio.expansion(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSector() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.isUse()) break block4;
                return -1;
            }
            return this.sectorSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                return null;
            }
            return this.baseio.getName();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int length() {
        Object object = this.sync;
        synchronized (object) {
            block4: {
                if (this.isUse()) break block4;
                return -1;
            }
            return this.baseio.length();
        }
    }

    public byte[] read(int no) throws Exception {
        byte[] ret = new byte[this.sectorSize];
        this.read(ret, no);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(byte[] out, int no) throws Exception {
        if (out == null || out.length != this.sectorSize || no < 0 || no >= this.baseio.length()) {
            if (out == null) {
                throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0 || no >= this.baseio.length()) {
                throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059[" + no + "/" + this.baseio.length() + "]");
            }
        }
        Baseio bio = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            bio = this.baseio;
            MappingChild ch = this.manager.get(no);
            if (ch != null) {
                byte[] b = ch.get(no - ch.getStartPos());
                System.arraycopy(b, 0, out, 0, this.sectorSize);
                return;
            }
        }
        bio.read(out, no);
    }

    public void write(byte[] in, int no) throws Exception {
        this.write(false, in, no);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(boolean mode, byte[] in, int no) throws Exception {
        if (in == null || no < 0 || no >= this.baseio.length()) {
            if (in == null) {
                throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            if (no < 0 || no >= this.baseio.length()) {
                throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059[" + no + "/" + this.baseio.length() + "]");
            }
        }
        Baseio bio = null;
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (mode && in.length != this.sectorSize) {
                throw new IOException("\u66f8\u8fbc\u307f\u30d0\u30a4\u30ca\u30ea\u9577\u306f\u4e0d\u6b63\u3067\u3059");
            }
            bio = this.baseio;
            MappingChild ch = this.manager.get(no);
            if (ch != null) {
                int len = in.length;
                if (len >= this.sectorSize) {
                    len = this.sectorSize;
                }
                int p = no - ch.getStartPos();
                byte[] b = ch.get(p);
                System.arraycopy(in, 0, b, 0, len);
                ch.updatePos(p);
                if (this.manager.getUpdateSize() >= 32) {
                    this.flush();
                }
                return;
            }
        }
        bio.write(in, no);
    }

    public int getType() {
        return 2;
    }

    protected boolean isUse() {
        return this.baseio != null;
    }
}

