/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dao.dbms.ctbl;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.Record;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.dao.dbms.ctbl.Table;
import org.maachang.dao.dbms.ctbl.TableMaster;
import org.maachang.dao.dbms.ctbl.TableUtil;
import org.maachang.dao.dbms.kind.SupportKind;
import org.maachang.util.Digest;
import org.maachang.util.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTable {
    private static final Log LOG = LogFactory.getLog(CreateTable.class);
    private static final String VERSION_DIR = "_version";
    private static final String SRC_JOIN = "src_join";
    private static final String JOIN = ".join";
    private static final String IMAGE_JOIN = "@image";
    private static final String MASTER_CACHE_MODE = "master_cache";
    private static final String PARAM_HELP = "?";
    private static final String PARAM_CREATE = "create";
    private static final String PARAM_DROP = "drop";
    private static final String PARAM_MODEL = "model";
    private static final String PARAM_MASTER = "master";
    private static final String PARAM_VERSION = "version";
    private static final String TABLE_CONF = ".conf";
    private static final String MASTER_CSV = ".csv";
    private static final String MASTER_HEADER = ".header";
    private static final String MASTER_CSV_CHARSET = "SHIFT_JIS";
    private static final boolean TRANSACTION_MODE = false;

    private CreateTable() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void create(boolean mode, String basePath, String outDir, String param, RecordFactory factory) throws Exception {
        if (PARAM_HELP.equals(param = param == null || (param = param.trim()).length() <= 0 ? PARAM_CREATE : param.toLowerCase())) {
            CreateTable.viewHelp();
            return;
        }
        if (basePath == null || (basePath = basePath.trim()).length() <= 0) {
            if (mode) throw new IllegalArgumentException("\u30c6\u30fc\u30d6\u30eb\u30b3\u30f3\u30d5\u30a3\u30b0\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            System.out.println("\u30c6\u30fc\u30d6\u30eb\u30b3\u30f3\u30d5\u30a3\u30b0\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
            return;
        }
        if (factory == null) {
            if (mode) throw new IllegalArgumentException("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u5b9a\u7fa9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093.");
            System.out.println("\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u5b9a\u7fa9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093.");
            return;
        }
        SupportKind dbms = factory.getSupportKind();
        if (dbms == null) {
            if (mode) throw new IOException("\u30a2\u30c0\u30d7\u30bf\u540d\u304c\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3067\u3059.");
            System.out.println("\u30a2\u30c0\u30d7\u30bf\u540d\u304c\u975e\u30b5\u30dd\u30fc\u30c8\u306e\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3067\u3059.");
            return;
        }
        if (!mode) {
            System.out.println("## startup create table");
        } else {
            LOG.info((Object)"## startup create table");
        }
        Record record = null;
        try {
            try {
                Config tableConfig = null;
                Config lastVersionConfig = null;
                boolean execVersion = false;
                Table table = TableMaster.get(dbms.getAdapter());
                int version = CreateTable.getVersion(basePath);
                if (CreateTable.isNumber(param)) {
                    tableConfig = CreateTable.getVersionConfig(basePath, param);
                    if (tableConfig == null || tableConfig.size() <= 0) {
                        if (!mode) {
                            System.out.println("\u8aad\u307f\u8fbc\u307f\u53ef\u80fd\u306a\u30b3\u30f3\u30d5\u30a3\u30b0\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093.");
                            return;
                        }
                        LOG.info((Object)"\u8aad\u307f\u8fbc\u307f\u53ef\u80fd\u306a\u30b3\u30f3\u30d5\u30a3\u30b0\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093.");
                        return;
                    }
                    execVersion = true;
                } else {
                    if (param.endsWith(PARAM_VERSION)) {
                        System.out.println("version " + version);
                        return;
                    }
                    if (param.endsWith(PARAM_MASTER)) {
                        if (!mode) {
                            System.out.println("master\u30d5\u30a1\u30a4\u30eb\u3092DB\u306b\u66f8\u304d\u8fbc\u307f\u307e\u3059");
                        } else {
                            LOG.info((Object)"master\u30d5\u30a1\u30a4\u30eb\u3092DB\u306b\u66f8\u304d\u8fbc\u307f\u307e\u3059");
                        }
                        tableConfig = CreateTable.readTableConfig(mode, basePath);
                        record = factory.getRecord();
                        record.getConnection().setAutoCommit(false);
                        CreateTable.insertMaster(mode, table, tableConfig, record, basePath);
                        return;
                    }
                    tableConfig = CreateTable.readTableConfig(mode, basePath);
                    if (tableConfig == null || tableConfig.size() <= 0) {
                        if (!mode) {
                            System.out.println("\u8aad\u307f\u8fbc\u307f\u53ef\u80fd\u306a\u30b3\u30f3\u30d5\u30a3\u30b0\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093.");
                            return;
                        }
                        LOG.info((Object)"\u8aad\u307f\u8fbc\u307f\u53ef\u80fd\u306a\u30b3\u30f3\u30d5\u30a3\u30b0\u30d5\u30a1\u30a4\u30eb\u306f\u5b58\u5728\u3057\u307e\u305b\u3093.");
                        return;
                    }
                    if (param.equals(PARAM_DROP)) {
                        if (!mode) {
                            System.out.println("\u30c6\u30fc\u30d6\u30eb\u3092\u524a\u9664.");
                        } else {
                            LOG.info((Object)"\u30c6\u30fc\u30d6\u30eb\u3092\u524a\u9664.");
                        }
                        if (version > 0) {
                            tableConfig = CreateTable.getVersionConfig(basePath, String.valueOf(version));
                        }
                        record = factory.getRecord();
                        record.getConnection().setAutoCommit(false);
                        CreateTable.dropTable(mode, table, record, tableConfig);
                        CreateTable.deleteVersionInfo(basePath);
                        return;
                    }
                    if (param.equals(PARAM_MODEL)) {
                        if (!mode) {
                            System.out.println("model\u30d5\u30a1\u30a4\u30eb\u306e\u307f\u3092\u51fa\u529b.");
                        } else {
                            LOG.info((Object)"model\u30d5\u30a1\u30a4\u30eb\u306e\u307f\u3092\u51fa\u529b.");
                        }
                        CreateTable.fileOutModel(true, table, dbms, outDir, tableConfig);
                        return;
                    }
                }
                if (version > 0) {
                    lastVersionConfig = CreateTable.getVersionConfig(basePath, String.valueOf(version));
                }
                if (table == null) {
                    if (!mode) {
                        System.out.println("\u5bfe\u8c61\u30a2\u30c0\u30d7\u30bf\u540d[" + dbms.getAdapter() + "]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                        return;
                    }
                    LOG.info((Object)("\u5bfe\u8c61\u30a2\u30c0\u30d7\u30bf\u540d[" + dbms.getAdapter() + "]\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093"));
                    return;
                }
                CreateTable.fileOutModel(false, table, dbms, outDir, tableConfig);
                String sql = null;
                if (lastVersionConfig == null) {
                    sql = table.createTable(tableConfig);
                } else {
                    if (CreateTable.equlasConfig(tableConfig, lastVersionConfig)) {
                        if (!mode) {
                            System.out.println("\u30c6\u30fc\u30d6\u30eb\u5185\u5bb9\u306b\u5909\u66f4\u70b9\u306f\u3042\u308a\u307e\u305b\u3093");
                            return;
                        }
                        LOG.info((Object)"\u30c6\u30fc\u30d6\u30eb\u5185\u5bb9\u306b\u5909\u66f4\u70b9\u306f\u3042\u308a\u307e\u305b\u3093");
                        return;
                    }
                    sql = CreateTable.partSQL(table, tableConfig, lastVersionConfig);
                }
                if (sql == null || (sql = sql.trim()).length() <= 0) {
                    if (!mode) {
                        System.out.println("\u5b9f\u884c\u53ef\u80fd\u306aSQL\u6587\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        return;
                    }
                    LOG.info((Object)"\u5b9f\u884c\u53ef\u80fd\u306aSQL\u6587\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                    return;
                }
                record = factory.getRecord();
                record.getConnection().setAutoCommit(false);
                CreateTable.executionBySql(mode, record, sql);
                if (execVersion) {
                    if (!mode) {
                        System.out.println("## version " + param + TABLE_CONF + " \u3092\u5b9f\u884c.");
                    } else {
                        LOG.info((Object)("## version " + param + TABLE_CONF + " \u3092\u5b9f\u884c."));
                    }
                }
                CreateTable.outputVersionConfig(mode, basePath, version, tableConfig);
                return;
            }
            finally {
                if (record != null) {
                    try {
                        record.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        catch (Exception e) {
            if (record != null) {
                try {
                    record.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!mode) {
                System.out.println("## error");
                e.printStackTrace();
                return;
            }
            LOG.info((Object)"## error", (Throwable)e);
            return;
        }
    }

    private static final void executionBySql(boolean mode, Record record, String sql) throws Exception {
        BufferedReader buf = null;
        try {
            String one;
            long tm = System.currentTimeMillis();
            buf = new BufferedReader(new StringReader(sql));
            while ((one = buf.readLine()) != null) {
                if (!mode) {
                    System.out.println(">" + one);
                } else {
                    LOG.info((Object)(">" + one));
                }
                try {
                    record.executeUpdate(one);
                    try {
                        record.commit();
                    }
                    catch (Exception ee) {
                        try {
                            record.rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (!mode) {
                        System.out.println(".....OK.");
                    } else {
                        LOG.info((Object)".....OK.");
                    }
                }
                catch (Exception e) {
                    try {
                        record.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String x = one.trim().toLowerCase();
                    if (x.startsWith("create ") || x.startsWith("alter ") && x.indexOf(" add ") != -1) {
                        throw e;
                    }
                    if (!mode) {
                        System.out.println(".....>>" + e);
                    }
                    LOG.info((Object)(".....>>" + e));
                }
                if (mode) continue;
                System.out.println("");
            }
            try {
                record.commit();
            }
            catch (Exception ee) {
                try {
                    record.rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!mode) {
                System.out.println("## success:" + (System.currentTimeMillis() - tm) + "ms");
            } else {
                LOG.info((Object)("## success:" + (System.currentTimeMillis() - tm) + "ms"));
            }
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final void dropTable(boolean mode, Table table, Record record, Config config) throws Exception {
        Object[] sections = config.getSections();
        if (sections != null && sections.length > 0) {
            int len = sections.length;
            int i = 0;
            while (i < len) {
                if (sections[i] != null && ((String)(sections[i] = ((String)sections[i]).trim())).length() > 0) {
                    int j = 0;
                    while (j < 3) {
                        block23: {
                            String dropSQL = null;
                            try {
                                switch (j) {
                                    case 0: {
                                        dropSQL = "drop table " + sections[i] + table.getSemicolon() + "\n";
                                        break;
                                    }
                                    case 1: {
                                        dropSQL = "drop sequence " + sections[i] + "_id_seq" + table.getSemicolon() + "\n";
                                        break;
                                    }
                                    case 2: {
                                        dropSQL = "alter table " + sections[i] + " drop constraint " + sections[i] + "_pk " + table.getSemicolon() + "\n";
                                    }
                                }
                                if (dropSQL == null) break block23;
                                if (!mode) {
                                    System.out.println(">" + dropSQL);
                                } else {
                                    LOG.info((Object)(">" + dropSQL));
                                }
                                record.executeUpdate(dropSQL);
                                try {
                                    record.commit();
                                }
                                catch (Exception ee) {
                                    try {
                                        record.rollback();
                                    }
                                    catch (Exception exception) {}
                                }
                            }
                            catch (Exception e) {
                                if (!mode) {
                                    System.out.println("error:" + e.getMessage());
                                } else {
                                    LOG.info((Object)("error:" + e.getMessage()));
                                }
                                try {
                                    record.rollback();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        ++j;
                    }
                    if (!mode) {
                        System.out.println("drop table " + sections[i]);
                    } else {
                        LOG.info((Object)("drop table " + sections[i]));
                    }
                }
                ++i;
            }
        }
    }

    private static final Config readTableConfig(boolean mode, String path) throws Exception {
        String readPath = String.valueOf(FileUtil.getFullPath((String)path)) + FileUtil.FILE_SPACE;
        Config conf = new Config();
        int cnt = CreateTable.readByDir(mode, conf, 0, readPath);
        if (!mode) {
            System.out.println("@@@@ read config [END:" + cnt + "]");
        } else {
            LOG.info((Object)("@@@@ read config [END:" + cnt + "]"));
        }
        return conf;
    }

    private static final int readByDir(boolean mode, Config conf, int cnt, String base) throws Exception {
        String[] list;
        String dir = base;
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + FileUtil.FILE_SPACE;
        }
        if ((list = FileUtil.getFileDirList((String)dir)) != null && list.length > 0) {
            int len = list.length;
            int i = 0;
            while (i < len) {
                String c = String.valueOf(dir) + list[i];
                if (FileUtil.isDirExists((String)c)) {
                    cnt = CreateTable.readByDir(mode, conf, cnt, c);
                } else if (FileUtil.isRead((String)c) && c.endsWith(TABLE_CONF)) {
                    if (!mode) {
                        System.out.println("-- readFile:[" + list[i] + "]");
                    } else {
                        LOG.info((Object)("-- readFile:[" + list[i] + "]"));
                    }
                    CreateTable.getIniParams(conf, c);
                    ++cnt;
                }
                list[i] = null;
                ++i;
            }
        }
        return cnt;
    }

    private static final void getIniParams(Config out, String name) throws Exception {
        BufferedReader buf = null;
        try {
            buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "UTF8"));
            ReadIni.analisys((Config)out, (BufferedReader)buf);
            buf.close();
            buf = null;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception exception) {}
            }
            buf = null;
        }
    }

    private static final void fileOutModel(boolean mode, Table table, SupportKind dbms, String outDir, Config config) throws Exception {
        Object[] o = config.getSections();
        if (o == null && o.length <= 0) {
            return;
        }
        if (outDir.endsWith("\\") || outDir.endsWith("/")) {
            outDir = outDir.substring(0, outDir.length() - 1);
        }
        int len = o.length;
        String date = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date());
        int i = 0;
        while (i < len) {
            String s = (String)o[i];
            if (s != null && (s = s.trim()).length() > 0) {
                String section = s;
                String javaName = DbUtil.convertDBNameByJavaName(true, s);
                s = String.valueOf(outDir) + "/" + javaName + ".ms";
                if (mode || !FileUtil.isFileExists((String)s)) {
                    String defaultParam;
                    String join;
                    StringBuilder buf = new StringBuilder();
                    buf.append("// ").append(javaName).append(" \u30e2\u30c7\u30eb.").append("\n");
                    buf.append("// ").append(date).append("\n");
                    buf.append("// ").append("\n");
                    String srcJoin = CreateTable.srcJoinInfo(config, section);
                    if (srcJoin != null) {
                        buf.append("\n");
                        buf.append(srcJoin);
                        buf.append("\n");
                    }
                    if ((join = CreateTable.joinInfo(config, section)) != null) {
                        buf.append("\n");
                        buf.append(join);
                        buf.append("\n");
                    }
                    if ((defaultParam = CreateTable.defaultParam(config, section, table, dbms)) != null) {
                        buf.append("\n");
                        buf.append(defaultParam);
                        buf.append("\n");
                    }
                    if (config.getBoolean(section, MASTER_CACHE_MODE, 0) || section.endsWith(PARAM_MASTER)) {
                        buf.append("\n");
                        buf.append("// ** \u30de\u30b9\u30bf\u30fc\u30ad\u30e3\u30c3\u30b7\u30e5ON. **\n");
                        buf.append(DbUtil.convertDBNameByJavaName(true, section));
                        buf.append(".isCacheMap=true ;\n");
                        buf.append("\n");
                    }
                    FileUtil.setFileByString((String)s, (String)buf.toString());
                    buf = null;
                }
            }
            ++i;
        }
    }

    private static final String srcJoinInfo(Config config, String section) {
        String[] srcJoin = config.getAll(section, SRC_JOIN);
        if (srcJoin != null && srcJoin.length > 0) {
            StringBuilder buf = new StringBuilder();
            int len = srcJoin.length;
            buf.append("// ** \u7d50\u5408\u5143\u30ab\u30e9\u30e0. **\n");
            buf.append(DbUtil.convertDBNameByJavaName(true, section)).append(".").append("srcJoin = [");
            int i = 0;
            while (i < len) {
                if (i != 0) {
                    buf.append(",");
                }
                buf.append("\"").append(DbUtil.convertDBNameByJavaName(true, srcJoin[i])).append("\"");
                ++i;
            }
            config.removeKey(section, SRC_JOIN);
            buf.append("] ;\n");
            return buf.toString();
        }
        return null;
    }

    private static final String joinInfo(Config config, String section) {
        String[] keys = config.getKeys(section);
        int cnt = 0;
        if (keys != null && keys.length > 0) {
            int len = keys.length;
            HashSet<String> imageJoin = new HashSet<String>();
            String javaName = DbUtil.convertDBNameByJavaName(true, section);
            StringBuilder buf = new StringBuilder();
            buf.append("// ** \u7d50\u5408\u30ab\u30e9\u30e0. **\n");
            buf.append(javaName).append(JOIN).append("= {");
            int i = 0;
            while (i < len) {
                String key = keys[i].toLowerCase();
                if (key.endsWith(JOIN)) {
                    String value = config.get(section, keys[i], 0);
                    if (value != null && (value = value.trim()).length() > 0) {
                        if (value.equals(IMAGE_JOIN)) {
                            imageJoin.add(key.substring(0, key.length() - JOIN.length()));
                        } else {
                            if (cnt != 0) {
                                buf.append(",");
                            }
                            String joinKey = key.substring(0, key.length() - JOIN.length());
                            joinKey = DbUtil.convertDBNameByJavaName(false, joinKey);
                            buf.append("\"").append(joinKey).append("\":").append("\"").append(DbUtil.convertDBNameByJavaName(true, value)).append("\"");
                            ++cnt;
                        }
                    }
                    config.removeKey(section, keys[i]);
                }
                ++i;
            }
            keys = null;
            boolean useFlag = false;
            if (cnt != 0) {
                buf.append("} ;");
                useFlag = true;
            }
            if (imageJoin.size() > 0) {
                if (useFlag) {
                    buf.append("\n\n");
                } else {
                    buf = new StringBuilder();
                }
                useFlag = true;
                buf.append("// ** image\u7d50\u5408\u30ab\u30e9\u30e0. **\n");
                buf.append(javaName).append(".imageJoin").append("= [");
                Object[] o = imageJoin.toArray();
                len = imageJoin.size();
                int i2 = 0;
                while (i2 < len) {
                    if (i2 != 0) {
                        buf.append(",");
                    }
                    buf.append("\"").append(DbUtil.convertDBNameByJavaName(false, (String)o[i2])).append("\"");
                    ++i2;
                }
                buf.append("] ;\n");
            }
            if (useFlag) {
                return buf.toString();
            }
        }
        return null;
    }

    private static final String defaultParam(Config config, String section, Table table, SupportKind dbms) {
        String[] keys = config.getKeys(section);
        if (keys != null && keys.length > 0) {
            int len = keys.length;
            HashMap<String, String> map = new HashMap<String, String>();
            int chkPos = "default".length();
            int i = 0;
            while (i < len) {
                int lenJ = config.size(section, keys[i]);
                int j = 0;
                while (j < lenJ) {
                    char c;
                    String value = config.get(section, keys[i], j);
                    if (value != null && (value = value.trim()).length() > 0 && value.startsWith("default") && ((c = value.charAt(chkPos)) == '\'' || c == ' ' || c == '\"')) {
                        String def = TableUtil.getDefault(value);
                        map.put(keys[i], def);
                    }
                    ++j;
                }
                ++i;
            }
            keys = null;
            Object[] o = map.keySet().toArray();
            if (o != null && o.length > 0) {
                String javaName = DbUtil.convertDBNameByJavaName(true, section);
                StringBuffer buf = new StringBuffer();
                buf.append("// ** \u30c7\u30d5\u30a9\u30eb\u30c8\u5024. **\n");
                buf.append(javaName).append(".defaultColumns = { ");
                len = o.length;
                int i2 = 0;
                while (i2 < len) {
                    String v;
                    if (i2 != 0) {
                        buf.append(", ");
                    }
                    if ((v = (String)map.get((String)o[i2])) != null && v.length() > 0) {
                        buf.append("\"").append(DbUtil.convertDBNameByJavaName(false, (String)o[i2])).append("\":");
                        if (v.equals("true") || v.equals("false") || CreateTable.checkNumber(v)) {
                            buf.append(v);
                        } else {
                            buf.append("\"").append(v).append("\"");
                        }
                    }
                    ++i2;
                }
                buf.append(" } ;\n");
                o = null;
                map = null;
                return buf.toString();
            }
        }
        return null;
    }

    private static final boolean checkNumber(String s) {
        boolean ret = false;
        try {
            Double.parseDouble(s);
            ret = true;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }

    private static final void deleteVersionInfo(String baseDir) throws Exception {
        String dir;
        if (baseDir.endsWith("\\") || baseDir.endsWith("/")) {
            baseDir = baseDir.substring(0, baseDir.length() - 1);
        }
        if (!FileUtil.isDirExists((String)(dir = baseDir + FileUtil.FILE_SPACE + VERSION_DIR + FileUtil.FILE_SPACE))) {
            return;
        }
        String[] tmp = FileUtil.getFileDirList((String)dir);
        if (tmp == null || tmp.length <= 0) {
            return;
        }
        int len = tmp.length;
        int i = 0;
        while (i < len) {
            if (tmp[i] != null && tmp[i].length() > 0 && tmp[i].endsWith(TABLE_CONF)) {
                FileUtil.removeFile((String)(String.valueOf(dir) + tmp[i]));
            }
            ++i;
        }
    }

    private static final int getVersion(String baseDir) throws Exception {
        String dir;
        if (baseDir.endsWith("\\") || baseDir.endsWith("/")) {
            baseDir = baseDir.substring(0, baseDir.length() - 1);
        }
        if (!FileUtil.isDirExists((String)(dir = baseDir + FileUtil.FILE_SPACE + VERSION_DIR + FileUtil.FILE_SPACE))) {
            return -1;
        }
        String[] tmp = FileUtil.getFileDirList((String)dir);
        if (tmp == null || tmp.length <= 0) {
            return -1;
        }
        ArrayList<Integer> lst = new ArrayList<Integer>();
        int len = tmp.length;
        int i = 0;
        while (i < len) {
            String s;
            if (tmp[i] != null && tmp[i].length() > 0 && tmp[i].endsWith(TABLE_CONF) && CreateTable.isNumber(s = tmp[i].substring(0, tmp[i].length() - TABLE_CONF.length()))) {
                lst.add(new Integer(s));
            }
            ++i;
        }
        if (lst.size() <= 0) {
            return -1;
        }
        tmp = null;
        len = lst.size();
        int ret = 0;
        int i2 = 0;
        while (i2 < len) {
            Integer t = (Integer)lst.get(i2);
            if (ret < t) {
                ret = t;
            }
            ++i2;
        }
        return ret;
    }

    private static final Config getVersionConfig(String baseDir, String version) throws Exception {
        String file;
        if (baseDir.endsWith("\\") || baseDir.endsWith("/")) {
            baseDir = baseDir.substring(0, baseDir.length() - 1);
        }
        if (!FileUtil.isFileExists((String)(file = baseDir + FileUtil.FILE_SPACE + VERSION_DIR + FileUtil.FILE_SPACE + version + TABLE_CONF))) {
            return null;
        }
        Config conf = new Config();
        CreateTable.getIniParams(conf, file);
        return conf;
    }

    private static final void outputVersionConfig(boolean mode, String baseDir, int version, Config config) throws Exception {
        String dir;
        if (baseDir.endsWith("\\") || baseDir.endsWith("/")) {
            baseDir = baseDir.substring(0, baseDir.length() - 1);
        }
        if (!FileUtil.isDirExists((String)(dir = baseDir + FileUtil.FILE_SPACE + VERSION_DIR + FileUtil.FILE_SPACE))) {
            version = -1;
            FileUtil.mkdirs((String)dir);
        }
        String versionName = null;
        versionName = version <= -1 ? "1.conf" : version + 1 + TABLE_CONF;
        String data = CreateTable.allConfig(false, config);
        if (data == null || data.length() <= 0) {
            if (!mode) {
                System.out.println("## version " + versionName + " \u3092\u51fa\u529b\u306b\u5931\u6557.");
            } else {
                LOG.error((Object)("## version " + versionName + " \u3092\u51fa\u529b\u306b\u5931\u6557."));
            }
            return;
        }
        FileUtil.setFileByString((String)(String.valueOf(dir) + versionName), (String)data);
        if (!mode) {
            System.out.println("## version " + versionName + " \u3092\u51fa\u529b.");
        } else {
            LOG.info((Object)("## version " + versionName + " \u3092\u51fa\u529b."));
        }
    }

    private static final String allConfig(boolean createMode, Config config) throws Exception {
        Object[] o = config.getSections();
        if (o == null || o.length <= 0) {
            return null;
        }
        Arrays.sort(o);
        int len = o.length;
        StringBuilder buf = new StringBuilder();
        int cnt = 0;
        int i = 0;
        while (i < len) {
            Object[] keys;
            String section = (String)o[i];
            if (section != null && (section = section.trim()).length() > 0 && (keys = config.getKeys(section = section.toLowerCase())) != null && keys.length > 0) {
                Arrays.sort(keys);
                int lenJ = keys.length;
                if (cnt != 0) {
                    buf.append("\n");
                }
                buf.append("[").append(section).append("]\n");
                int j = 0;
                while (j < lenJ) {
                    if (keys[j] != null && ((String)(keys[j] = ((String)keys[j]).trim())).length() > 0) {
                        Object[] all;
                        Object key = keys[j];
                        if (!(createMode && (((String)key).toLowerCase().equals(SRC_JOIN) || ((String)key).toLowerCase().equals(MASTER_CACHE_MODE) || ((String)key).toLowerCase().endsWith(JOIN)) || (all = config.getAll(section, (String)key)) == null || all.length <= 0)) {
                            CreateTable.trimArray((String[])all);
                            Arrays.sort(all);
                            int lenK = all.length;
                            int k = 0;
                            while (k < lenK) {
                                if (all[k] != null) {
                                    buf.append((String)key).append("=").append("\"").append((String)all[k]).append("\"\n");
                                }
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                ++cnt;
            }
            ++i;
        }
        return buf.toString();
    }

    private static final boolean equlasConfig(Config src, Config dest) throws Exception {
        String srcStr = Digest.convert((String)"SHA1", (byte[])CreateTable.allConfig(true, src).getBytes("UTF8"));
        String destStr = Digest.convert((String)"SHA1", (byte[])CreateTable.allConfig(true, dest).getBytes("UTF8"));
        return srcStr.equals(destStr);
    }

    private static final String partSQL(Table table, Config src, Config dest) throws Exception {
        if (src.size() <= 0 || dest.size() <= 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        HashSet<String> createKeyTable = new HashSet<String>();
        Object[] srcTable = src.getSections();
        int len = srcTable.length;
        int i = 0;
        while (i < len) {
            String tableName = (String)srcTable[i];
            if (table != null && (tableName = tableName.trim()).length() > 0 && src.size(tableName) > 0) {
                if (!dest.isSection(tableName)) {
                    buf.append(table.createTable(tableName, src));
                } else {
                    String[] keys = src.getKeys(tableName);
                    if (keys != null && keys.length > 0) {
                        int lenJ = keys.length;
                        int j = 0;
                        while (j < lenJ) {
                            String key = keys[j];
                            if (!(key == null || (key = key.trim()).length() <= 0 || "id".equals(key.toLowerCase()) || TableUtil.isType(key) || dest.isKeys(tableName, key))) {
                                buf.append(table.addColumn(tableName, key, src));
                                if (CreateTable.isPrimaryKey(src, tableName, key)) {
                                    createKeyTable.add(tableName);
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
        srcTable = null;
        Object[] destTable = dest.getSections();
        len = destTable.length;
        int i2 = 0;
        while (i2 < len) {
            String tableName = (String)destTable[i2];
            if (table != null && (tableName = tableName.trim()).length() > 0 && dest.size(tableName) > 0) {
                if (!src.isSection(tableName)) {
                    String recreate = table.dropPrimaryKey(tableName);
                    if (recreate != null) {
                        buf.append(recreate);
                    }
                    if ((recreate = table.dropTable(tableName)) != null) {
                        buf.append(recreate);
                    }
                    if ((recreate = table.dropSequence(tableName)) != null) {
                        buf.append(recreate);
                    }
                } else {
                    String[] keys = dest.getKeys(tableName);
                    if (keys != null && keys.length > 0) {
                        int lenJ = keys.length;
                        int j = 0;
                        while (j < lenJ) {
                            String key = keys[j];
                            if (!(key == null || (key = key.trim()).length() <= 0 || "id".equals(key.toLowerCase()) || TableUtil.isType(key) || src.isKeys(tableName, key))) {
                                buf.append(table.dropColumn(tableName, key));
                                if (CreateTable.isPrimaryKey(dest, tableName, key)) {
                                    createKeyTable.add(tableName);
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i2;
        }
        destTable = null;
        if (createKeyTable.size() > 0) {
            String addSql = buf.toString();
            buf = new StringBuilder();
            Object[] pks = createKeyTable.toArray();
            len = pks.length;
            int i3 = 0;
            while (i3 < len) {
                String pk = (String)pks[i3];
                if (pk != null && (pk = pk.trim()).length() > 0) {
                    buf.append(table.dropPrimaryKey(pk));
                    if (src.isSection(pk)) {
                        addSql = String.valueOf(addSql) + table.addPrimaryKey(pk, src);
                    }
                }
                ++i3;
            }
            buf.append(addSql);
        }
        return buf.toString();
    }

    private static final boolean isPrimaryKey(Config config, String table, String key) {
        String[] one = config.getAll(table, key);
        int len = one.length;
        int i = 0;
        while (i < len) {
            if (TableUtil.isIndex(one[i]) || TableUtil.isKey(one[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final boolean isNumber(String param) {
        try {
            Integer.parseInt(param);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static final void trimArray(String[] all) {
        int len = all.length;
        int i = 0;
        while (i < len) {
            if (all[i] == null || (all[i] = all[i].trim()).length() <= 0) {
                all[i] = null;
            }
            ++i;
        }
    }

    private static final void viewHelp() {
        System.out.println("maachangDao \u30c6\u30fc\u30d6\u30eb\u751f\u6210\u30d8\u30eb\u30d7.");
        System.out.println();
        System.out.println("create     : \u30c6\u30fc\u30d6\u30eb\u751f\u6210\u51e6\u7406\u3092\u884c\u3044\u307e\u3059.");
        System.out.println("             \u307e\u305f\u3001\u5f15\u6570\u306a\u3057\u3067\u3082\u540c\u69d8\u306e\u6761\u4ef6\u3092\u5b9f\u884c\u3057\u307e\u3059.");
        System.out.println("drop       : \u30c6\u30fc\u30d6\u30eb\u7834\u68c4\u304a\u3088\u3073\u30d0\u30fc\u30b8\u30e7\u30f3\u7834\u68c4\u3057\u307e\u3059.");
        System.out.println("model      : \u30e2\u30c7\u30eb\u30d5\u30a1\u30a4\u30eb\u3092\u518d\u751f\u6027\u3057\u307e\u3059.");
        System.out.println("master     : \u30de\u30b9\u30bf\u30fc\u30d5\u30a1\u30a4\u30eb(csv)\u3092\u30de\u30b9\u30bf\u30fc\u30c6\u30fc\u30d6\u30eb\u306b\u683c\u7d0d\u3057\u307e\u3059");
        System.out.println("version    : \u73fe\u5728\u306e\u30e2\u30c7\u30eb\u30d0\u30fc\u30b8\u30e7\u30f3\u3092\u8868\u793a\u3057\u307e\u3059.");
    }

    private static final void insertMaster(boolean mode, Table table, Config tableConfig, Record record, String base) throws Exception {
        String[] list;
        String dir = base;
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + FileUtil.FILE_SPACE;
        }
        if ((list = FileUtil.getFileDirList((String)dir)) != null && list.length > 0) {
            int len = list.length;
            int i = 0;
            while (i < len) {
                String c = String.valueOf(dir) + list[i];
                if (FileUtil.isDirExists((String)c)) {
                    CreateTable.insertMaster(mode, table, tableConfig, record, c);
                } else if (FileUtil.isRead((String)c) && c.endsWith(MASTER_CSV)) {
                    if (!mode) {
                        System.out.println("-- readMasterFile(start):[" + list[i] + "]");
                    } else {
                        LOG.info((Object)("-- readMastarFile(start):[" + list[i] + "]"));
                    }
                    int[] columnLength = new int[1];
                    ArrayList<String> columnTypes = new ArrayList<String>();
                    String columnNames = CreateTable.getHeaderColumns(mode, columnLength, columnTypes, tableConfig, table, c);
                    int cnt = CreateTable.insertMasterCsv(mode, table, tableConfig, record, c, columnNames, columnTypes, columnLength);
                    if (!mode) {
                        System.out.println("-- readMasterFile(end):[" + list[i] + "] success:" + cnt);
                    } else {
                        LOG.info((Object)("-- readMastarFile(end):[" + list[i] + "] success:" + cnt));
                    }
                }
                list[i] = null;
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static final int insertMasterCsv(boolean mode, Table tbl, Config tableConfig, Record record, String name, String header, ArrayList<String> columnTypes, int[] headerColumnLen) throws Exception {
        file = FileUtil.getFileName((String)name);
        table = file.substring(0, file.length() - ".csv".length());
        table = DbUtil.convertJavaNameByDBName(table);
        file = null;
        br = null;
        columnLength = 0;
        try {
            buf = null;
            columns = null;
            idFlag = false;
            supportBoolean = record.getSupportKind().isBoolean();
            useLength = 0;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "SHIFT_JIS"));
            cnt = 0;
            while ((line = br.readLine()) != null) {
                if (cnt != 0) ** GOTO lbl73
                if (header == null) {
                    lst = DbUtil.cutCsv(false, line, ",");
                    if (lst == null || lst.size() <= 0) {
                        return 0;
                    }
                    len = lst.size();
                    columnLength = 0;
                    if (!tbl.isInsertId()) {
                        i = 0;
                        while (i < len) {
                            if ("id".equals(lst.get(i).toLowerCase())) {
                                idFlag = false;
                                lst.remove(i);
                                --i;
                            } else {
                                ++columnLength;
                            }
                            ++i;
                        }
                        len = lst.size();
                    } else {
                        i = 0;
                        while (i < len) {
                            if ("id".equals(lst.get(i).toLowerCase())) {
                                idFlag = true;
                            }
                            ++columnLength;
                            ++i;
                        }
                    }
                    buf = new StringBuilder();
                    buf.append("insert into ").append(table).append(" (");
                    if (tbl.isInsertId() && !idFlag) {
                        buf.append("id,");
                    }
                    i = 0;
                    while (i < len) {
                        if (i != 0) {
                            buf.append(",");
                        }
                        if (CreateTable.getsColumnByType(columnTypes, tableConfig, tbl, table, col = lst.get(i).trim())) {
                            buf.append(DbUtil.convertJavaNameByDBName(col));
                        } else {
                            --columnLength;
                        }
                        ++i;
                    }
                    lst.clear();
                    lst = null;
                    buf.append(") values(");
                    columns = buf.toString();
                    buf = null;
                    CreateTable.masterByDropTable(mode, table, tbl, tableConfig, record);
                } else {
                    columns = header;
                    columnLength = headerColumnLen[0];
                    CreateTable.masterByDropTable(mode, table, tbl, tableConfig, record);
lbl73:
                    // 2 sources

                    if ((lst = DbUtil.cutCsv(false, line, ",")) != null && lst.size() > 0) {
                        buf = new StringBuilder();
                        buf.append(columns);
                        len = lst.size();
                        if (columnLength != len) {
                            if (!mode) {
                                System.out.println("table[" + table + "]:\u30ab\u30a6\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u306a\u3044(" + columnLength + "/" + len + ")");
                            } else {
                                CreateTable.LOG.info((Object)("table[" + table + "]:\u30ab\u30a6\u30f3\u30c8\u304c\u4e00\u81f4\u3057\u306a\u3044(" + columnLength + "/" + len + ")"));
                            }
                        } else {
                            if (tbl.isInsertId() && !idFlag) {
                                seqCnt = CreateTable.getSequenceId(record, table);
                                buf.append(seqCnt).append(",");
                            }
                            i = 0;
                            while (i < len) {
                                if (i != 0) {
                                    buf.append(",");
                                }
                                if ((value = lst.get(i).trim()) == null || value.length() <= 0) {
                                    value = "null";
                                } else if (!supportBoolean) {
                                    v = value.toLowerCase();
                                    if ("false".equals(v)) {
                                        value = "'" + tbl.getBooleanByFalse() + "'";
                                    } else if ("true".equals(v)) {
                                        value = "'" + tbl.getBooleanByTrue() + "'";
                                    }
                                }
                                type = columnTypes.get(i);
                                if ("char".equals(type) || "text".equals(type)) {
                                    if (!value.startsWith("\"") && !value.startsWith("'")) {
                                        buf.append("'").append(value).append("'");
                                    } else {
                                        buf.append(value);
                                    }
                                } else {
                                    buf.append(tbl.convertTypeToData(type, value));
                                }
                                ++i;
                            }
                            buf.append(")");
                            lst.clear();
                            lst = null;
                            sql = buf.toString();
                            buf = null;
                            if (!mode) {
                                System.out.println(">sql:" + sql);
                            } else {
                                CreateTable.LOG.info((Object)(">sql:" + sql));
                            }
                            try {
                                record.executeUpdate(sql);
                                record.commit();
                                ++useLength;
                            }
                            catch (Exception ee) {
                                if (!mode) {
                                    System.out.println("insert(" + table + ")-error:" + ee.getMessage());
                                } else {
                                    CreateTable.LOG.info((Object)("insert(" + table + ")-error:" + ee.getMessage()));
                                }
                                try {
                                    record.rollback();
                                }
                                catch (Exception var23_28) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                }
                ++cnt;
            }
            br.close();
            br = null;
            var25_32 = useLength;
            return var25_32;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception var26_29) {}
            }
            br = null;
        }
    }

    private static final long getSequenceId(Record record, String table) throws Exception {
        ResultSet rs = record.executeQuery(record.getSupportKind().getSequenceId(table));
        long ret = -1L;
        if (rs.next()) {
            ret = rs.getLong(1);
        }
        rs.close();
        rs = null;
        return ret;
    }

    private static final void masterByDropTable(boolean mode, String table, Table tbl, Config tableConfig, Record record) throws Exception {
        StringBuilder buf = new StringBuilder();
        String recreate = tbl.dropPrimaryKey(table);
        if (recreate != null) {
            buf.append(recreate);
        }
        if ((recreate = tbl.dropSequence(table)) != null) {
            buf.append(recreate);
        }
        if ((recreate = tbl.createTable(table, tableConfig)) != null) {
            buf.append(recreate);
            recreate = buf.toString();
            buf = null;
            CreateTable.executionBySql(mode, record, recreate);
        }
    }

    private static final String getHeaderColumns(boolean mode, int[] outColumnLen, ArrayList<String> columnTypes, Config tableConfig, Table tbl, String name) throws Exception {
        int columnLength = 0;
        outColumnLen[0] = 0;
        String file = FileUtil.getFileName((String)name);
        String table = file.substring(0, file.length() - MASTER_CSV.length());
        if (!FileUtil.isFileExists((String)(name = String.valueOf(name.substring(0, name.length() - MASTER_CSV.length())) + MASTER_HEADER))) {
            return null;
        }
        if (!mode) {
            System.out.println("read header:" + name);
        } else {
            LOG.info((Object)("read header:" + name));
        }
        BufferedReader br = null;
        try {
            int i;
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), MASTER_CSV_CHARSET));
            StringBuilder buf = null;
            boolean idFlag = false;
            do {
                if ((line = br.readLine()) != null) continue;
                String string = null;
                return string;
            } while ((line = line.trim()).length() <= 0);
            ArrayList<String> lst = DbUtil.cutCsv(false, line, ",");
            if (lst == null || lst.size() <= 0) {
                String string = null;
                return string;
            }
            int len = lst.size();
            columnLength = 0;
            if (!tbl.isInsertId()) {
                i = 0;
                while (i < len) {
                    if ("id".equals(lst.get(i).toLowerCase())) {
                        idFlag = false;
                        lst.remove(i);
                        --i;
                    } else {
                        ++columnLength;
                    }
                    ++i;
                }
                len = lst.size();
            } else {
                i = 0;
                while (i < len) {
                    if ("id".equals(lst.get(i).toLowerCase())) {
                        idFlag = true;
                    }
                    ++columnLength;
                    ++i;
                }
            }
            buf = new StringBuilder();
            buf.append("insert into ").append(table).append(" (");
            if (tbl.isInsertId() && !idFlag) {
                buf.append("id,");
            }
            i = 0;
            while (i < len) {
                String col;
                if (i != 0) {
                    buf.append(",");
                }
                if (CreateTable.getsColumnByType(columnTypes, tableConfig, tbl, table, col = lst.get(i).trim())) {
                    buf.append(DbUtil.convertJavaNameByDBName(col));
                } else {
                    --columnLength;
                }
                ++i;
            }
            lst.clear();
            lst = null;
            buf.append(") values(");
            String ret = buf.toString();
            buf = null;
            outColumnLen[0] = columnLength;
            String string = ret;
            return string;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
            br = null;
        }
    }

    private static final boolean getsColumnByType(ArrayList<String> columnTypes, Config tableConfig, Table table, String sectionName, String column) throws Exception {
        int len = tableConfig.size(sectionName, column);
        int i = 0;
        while (i < len) {
            String type = tableConfig.get(sectionName, column, i);
            if (type != null && (type = type.trim()).length() > 0) {
                int p = type.indexOf("(");
                if (p >= 0) {
                    type = type.substring(0, p);
                }
                type = type.trim();
                if ("boolean".equals(type = type.toLowerCase()) || "int".equals(type) || "long".equals(type) || "float".equals(type) || "double".equals(type) || "binary".equals(type) || "char".equals(type) || "text".equals(type) || "date".equals(type) || "time".equals(type) || "timestamp".equals(type)) {
                    columnTypes.add(type);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

