/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util;

import org.maachang.util.ArrayBinary;

public class BinaryUtil {
    public static final int binaryIndexOf(byte[] binary, byte[] data, int off) throws Exception {
        return BinaryUtil.binaryIndexOf(binary, data, off, 0);
    }

    public static final int binaryIndexOf(byte[] binary, byte[] data, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || data == null || data.length <= 0) {
            return -1;
        }
        int dataLen = data.length;
        if (len <= 0 || len >= binary.length) {
            len = binary.length;
        }
        int ret = -1;
        int i = off;
        while (i < len) {
            if (binary[i] == data[0] && i + dataLen <= len) {
                ret = i;
                int j = 1;
                while (j < dataLen) {
                    if (binary[i + j] != data[j]) {
                        ret = -1;
                        break;
                    }
                    ++j;
                }
                if (ret != -1) {
                    return ret;
                }
            }
            ++i;
        }
        return -1;
    }

    public static final byte[] subBinary(byte[] binary, int off) throws Exception {
        return BinaryUtil.subBinary(binary, off, 0);
    }

    public static final byte[] subBinary(byte[] binary, int off, int len) throws Exception {
        if (binary == null || binary.length <= 0 || off <= -1 || off >= binary.length) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (len <= 0) {
            len = binary.length;
        }
        if (binary.length <= off + len) {
            len = binary.length - off;
        }
        byte[] ret = new byte[len];
        System.arraycopy(binary, off, ret, 0, len);
        return ret;
    }

    public static final byte[] changeBinary(byte[] binary, byte[] src, byte[] dest) throws Exception {
        int end;
        int srcLen;
        ArrayBinary buf = null;
        if (binary == null || binary.length <= 0 || src == null || (srcLen = src.length) <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (dest == null || dest.length <= 0) {
            dest = new byte[]{};
        }
        buf = new ArrayBinary();
        int pnt = BinaryUtil.binaryIndexOf(binary, src, 0);
        if (pnt == -1) {
            return binary;
        }
        if (pnt == 0) {
            buf.write(dest);
            end = srcLen;
        } else {
            buf.write(BinaryUtil.subBinary(binary, 0, pnt));
            buf.write(dest);
            end = pnt + srcLen;
        }
        pnt += srcLen;
        while (true) {
            if ((pnt = BinaryUtil.binaryIndexOf(binary, src, pnt)) == -1) break;
            if (pnt == end) {
                buf.write(dest);
            } else {
                buf.write(BinaryUtil.subBinary(binary, end, pnt - end));
                buf.write(dest);
            }
            end = pnt + srcLen;
            pnt += srcLen;
        }
        buf.write(BinaryUtil.subBinary(binary, end));
        return buf.getBinary();
    }
}

