/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.thread;

public abstract class LoopThread
extends Thread {
    private volatile boolean stopFlag = true;

    protected abstract void clear();

    protected abstract boolean execution() throws Exception;

    protected void toException(Exception exception) {
    }

    public synchronized void startThread() throws Exception {
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void stopThread() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    protected synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            try {
                if (this.execution()) continue;
                Thread.sleep(30L);
            }
            catch (InterruptedException ite) {
                endFlag = true;
            }
            catch (NullPointerException ne) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (OutOfMemoryError mem) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (Exception e) {
                this.toException(e);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.clear();
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

