/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import org.maachang.dbm.engine.M2RawFlag;
import org.maachang.dbm.engine.M2SectorHeader;
import org.maachang.rawio.Baseio;
import org.maachang.rawio.Rawio;
import org.maachang.rawio.RawioInstance;
import org.maachang.rawio.mapping.Mappingio;
import org.maachang.util.ConvertParam;
import org.maachang.util.FileUtil;

class M2OneFileSector {
    public static final int MAX_ONE_FILE = 3500000;
    public static final String SECTOR_PLUS = ".sct2";
    private static final int SECTOR_OFFSET = 16;
    private static final int FIRST_SECTOR = 8192;
    private M2RawFlag flags = null;
    private Baseio io = null;
    private int fileNo = -1;
    private int startSectorPos = -1;
    private int nowFileSize = 0;
    private int nextAdd = 0;

    private M2OneFileSector() {
    }

    public M2OneFileSector(int fileNo, String dir, int size) throws Exception {
        M2RawFlag flg;
        String name;
        if (fileNo <= -1 || dir == null || (dir = dir.trim()).length() <= 0 || size <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!FileUtil.isDirExists((String)dir)) {
            throw new IllegalArgumentException("\u6307\u5b9a\u30c7\u30a3\u30ec\u30af\u30c8\u30ea[" + dir + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (size >= 3500000) {
            size = 3500000;
        }
        if (!dir.endsWith("/") && !dir.endsWith("\\")) {
            dir = String.valueOf(dir) + "/";
        }
        boolean newFile = !FileUtil.isFileExists((String)(name = dir + fileNo + SECTOR_PLUS));
        Baseio baseio = RawioInstance.open((boolean)true, (String)name);
        int flagSize = M2RawFlag.convertRect(baseio.getSector(), size);
        int bodySize = M2OneFileSector.convertSectorSize(baseio.getSector(), baseio.getSector() * 8192);
        if (baseio.length() == 0) {
            baseio.expansion(flagSize + bodySize);
        }
        this.flags = flg = new M2RawFlag(newFile, baseio, 0, size, flagSize);
        this.io = baseio;
        this.fileNo = fileNo;
        this.startSectorPos = flagSize;
        this.nowFileSize = baseio.length();
        this.nextAdd = this.nextAddSize(this.nowFileSize);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.flags != null) {
            this.flags.destroy();
        }
        if (this.io != null) {
            try {
                ((Mappingio)this.io).flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((Rawio)((Mappingio)this.io).getBaseio()).destroy();
        }
        this.flags = null;
        this.io = null;
        this.fileNo = -1;
        this.startSectorPos = -1;
        this.nowFileSize = -1;
        this.nextAdd = -1;
    }

    public int getPos() throws Exception {
        return this.flags.usePosBySet(0);
    }

    public void removePos(int no) throws Exception {
        this.flags.removePos(no);
    }

    public void read(M2SectorHeader outHeader, byte[] out, int no) throws Exception {
        this.read(outHeader, out, no, 0);
    }

    public void read(M2SectorHeader outHeader, byte[] out, int no, int offset) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        outHeader.clear();
        if (no >= 0) {
            byte[] b = this.io.read(no += this.startSectorPos);
            outHeader.setSectorType(ConvertParam.convertInt((int)0, (byte[])b));
            outHeader.setNextNo(ConvertParam.convertInt((int)4, (byte[])b));
            outHeader.setNextFileNo(ConvertParam.convertInt((int)8, (byte[])b));
            outHeader.setLength(ConvertParam.convertInt((int)12, (byte[])b));
            if (outHeader.getLength() > 0) {
                System.arraycopy(b, 16, out, offset, outHeader.getLength());
            }
        }
    }

    public void write(M2SectorHeader header, byte[] in, int no) throws Exception {
        this.write(header, in, no, 0);
    }

    public void write(M2SectorHeader header, byte[] in, int no, int offset) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (no >= 0) {
            this.plus(no);
            int sectorLen = this.io.getSector();
            no += this.startSectorPos;
            byte[] b = new byte[sectorLen];
            ConvertParam.convertInt((byte[])b, (int)0, (int)header.getSectorType());
            ConvertParam.convertInt((byte[])b, (int)4, (int)header.getNextNo());
            ConvertParam.convertInt((byte[])b, (int)8, (int)header.getNextFileNo());
            ConvertParam.convertInt((byte[])b, (int)12, (int)header.getLength());
            System.arraycopy(in, offset, b, 16, header.getLength());
            this.io.write(true, b, no);
        }
    }

    public String getName() {
        return this.io.getName();
    }

    public int getSector() {
        return this.io.getSector();
    }

    public synchronized int getFileNo() {
        return this.fileNo;
    }

    public int getSize() throws Exception {
        return this.flags.size();
    }

    public int getMax() throws Exception {
        return this.flags.maxSize();
    }

    private int nextAddSize(int now) {
        return now - this.startSectorPos;
    }

    private void plus(int no) throws Exception {
        if (this.nextAdd >= this.flags.maxSize()) {
            return;
        }
        if (no >= this.nextAdd) {
            this.nextAdd = (int)((double)this.nextAdd * 1.5);
            if (this.nextAdd >= this.flags.maxSize()) {
                this.nextAdd = this.flags.maxSize();
            }
            int x = this.nowFileSize - this.startSectorPos;
            x = this.nextAdd - x;
            this.io.expansion(x);
            this.nowFileSize = this.io.length();
        }
    }

    private synchronized boolean isUse() {
        return this.io != null;
    }

    private static final int convertSectorSize(int sector, int size) {
        int ret = size / sector;
        if (size % sector != 0) {
            ++ret;
        }
        return ret;
    }
}

