/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.util.Arrays;
import org.maachang.dbm.engine.M2RawHashFlag;
import org.maachang.dbm.engine.MDbmEnv;
import org.maachang.rawio.Rawio;
import org.maachang.rawio.RawioInstance;
import org.maachang.rawio.mapping.MappingOp;
import org.maachang.rawio.mapping.Mappingio;
import org.maachang.util.FileUtil;

public class M2RawHash {
    public static final int MAX_HASH_SIZE = MDbmEnv.HASH;
    private static final int FLAG_POS_OFFSET = M2RawHashFlag.convertRect(MDbmEnv.HASH);
    public static final int MASK_HASH = MAX_HASH_SIZE - 1;
    public static final int MAX_SEQUENCE_ID = 64;
    public static final int ONE_HASH = 8;
    private Mappingio io = null;
    private MappingOp op = null;
    private String filename = null;
    private int size = -1;
    private M2RawHashFlag posMan = null;
    private static final int SEQUENCE_OFFSET = FLAG_POS_OFFSET + MAX_HASH_SIZE * 8;
    private static final int DATA_SIZE_OFFSET = FLAG_POS_OFFSET + MAX_HASH_SIZE * 8 + 512;

    private M2RawHash() {
    }

    public M2RawHash(String filename) throws Exception {
        MappingOp op;
        if (filename == null || (filename = filename.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        filename = FileUtil.getFullPath((String)filename);
        boolean isFile = FileUtil.isFileExists((String)filename);
        Mappingio io = (Mappingio)RawioInstance.open((boolean)true, (String)filename);
        int sector = io.getSector();
        int all = FLAG_POS_OFFSET + MAX_HASH_SIZE * 8 + 512 + 4;
        all = all / sector + (all % sector != 0 ? 1 : 0);
        if (!isFile) {
            io.expansion(all);
            op = io.addMapping(0, all);
            M2RawHash.initFile(op);
        } else {
            op = io.addMapping(0, all);
        }
        M2RawHashFlag pflg = new M2RawHashFlag(op, MAX_HASH_SIZE);
        this.io = io;
        this.op = op;
        this.filename = filename;
        this.posMan = pflg;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.io != null) {
            try {
                this.io.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ((Rawio)this.io.getBaseio()).destroy();
        }
        this.io = null;
        this.op = null;
        this.filename = null;
        this.size = -1;
        this.posMan = null;
    }

    public synchronized void put(int hash, int pos, int fileNo) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (hash <= -1 || hash >= MAX_HASH_SIZE) {
            throw new IllegalArgumentException("\u6307\u5b9aHash\u30b3\u30fc\u30c9(" + hash + ")\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        this.op.writeLong((long)pos & 0xFFFFFFFFL | ((long)fileNo & 0xFFFFFFFFL) << 32, FLAG_POS_OFFSET + hash * 8);
        if (pos == -1 || fileNo == -1) {
            this.posMan.removePos(hash);
        } else {
            this.posMan.setPos(hash);
        }
    }

    public synchronized void remove(int hash) throws Exception {
        this.put(hash, -1, -1);
    }

    public synchronized long get(int hash) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (hash <= -1 || hash >= MAX_HASH_SIZE) {
            throw new IllegalArgumentException("\u6307\u5b9aHash\u30b3\u30fc\u30c9(" + hash + ")\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        return this.op.readLong(FLAG_POS_OFFSET + hash * 8);
    }

    public synchronized int useHash(int pos) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        return this.posMan.useNextPos(pos);
    }

    public synchronized String getFileName() {
        if (!this.check()) {
            return null;
        }
        return this.filename;
    }

    public synchronized long sequenceId(int no) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (no < 0 || no >= 64) {
            return -1L;
        }
        int off = SEQUENCE_OFFSET + no * 8;
        long ret = this.op.readLong(off);
        ret = ret >= Long.MAX_VALUE ? 0L : ++ret;
        this.op.writeLong(ret, off);
        return ret;
    }

    public synchronized void addOne() throws Exception {
        if (this.size <= -1) {
            this.readSize();
        }
        ++this.size;
        this.writeSize();
    }

    public synchronized void deleteOne() throws Exception {
        if (this.size <= -1) {
            this.readSize();
        }
        --this.size;
        if (this.size <= 0) {
            this.size = 0;
        }
        this.writeSize();
    }

    public synchronized int getSize() throws Exception {
        if (this.size <= -1) {
            this.readSize();
        }
        return this.size;
    }

    public synchronized boolean isUse() {
        return this.check();
    }

    private boolean check() {
        return this.op != null;
    }

    private static final void initFile(MappingOp op) throws Exception {
        int off = MAX_HASH_SIZE * 8 + FLAG_POS_OFFSET;
        byte[] b = new byte[off + 512 + 4];
        Arrays.fill(b, (byte)-1);
        int i = 0;
        while (i < FLAG_POS_OFFSET) {
            b[i] = 0;
            ++i;
        }
        i = 0;
        while (i < 64) {
            b[off] = 0;
            b[off + 1] = 0;
            b[off + 2] = 0;
            b[off + 3] = 0;
            b[off + 4] = 0;
            b[off + 5] = 0;
            b[off + 6] = 0;
            b[off + 7] = 0;
            off += 8;
            ++i;
        }
        op.writeBytes(b, 0, 0, b.length);
    }

    private void readSize() throws Exception {
        this.size = this.op.readInt(DATA_SIZE_OFFSET);
        if (this.size <= -1) {
            this.size = 0;
        }
    }

    private void writeSize() throws Exception {
        this.op.writeInt(this.size, DATA_SIZE_OFFSET);
    }
}

