/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.HttpdExecutionManager;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.HttpdResponseInstance;
import org.maachang.comet.httpd.engine.HttpdTimestamp;
import org.maachang.comet.httpd.engine.comet.Comet;
import org.maachang.comet.httpd.engine.comet.CometManager;
import org.maachang.comet.httpd.engine.script.BaseModelImpl;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.TargetScript;
import org.maachang.comet.httpd.engine.script.scripts.CometTriggerScript;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScript;
import org.maachang.manager.GlobalManager;
import org.maachang.util.FileUtil;

class HttpdScriptManager
implements HttpdExecutionManager {
    private static final Log LOG = LogFactory.getLog(HttpdScriptManager.class);
    private String appDirectory = null;
    private static final String SUCCESS_TRIGGER = "success";

    private HttpdScriptManager() {
    }

    public HttpdScriptManager(String currentDirectory) throws Exception {
        this.appDirectory = ScriptDef.trimCurrentDirectory(currentDirectory) + "application/";
    }

    protected void finalize() throws Exception {
        this.appDirectory = null;
    }

    public HttpdResponse get(HttpdRequest request) throws Exception {
        if (request == null) {
            throw new HttpdStateException(400, "\u30ea\u30af\u30a8\u30b9\u30c8\u304c\u4e0d\u6b63\u3067\u3059");
        }
        String path = HttpdScriptManager.trimPath(request.getUrlPath());
        if (path == null) {
            throw new HttpdStateException(404, "\u6307\u5b9a\u30d1\u30b9[" + request.getUrlPath() + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        HttpdResponse ret = null;
        try {
            if (path.endsWith(".mttml")) {
                TargetScript script = null;
                ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                ret.setHttpCache(true);
                ret.setHttpClose(false);
                if (!this.executionFilter(ret, path, request)) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    ret.setCookieSession(request);
                    ret.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(TemplateScript.getTime(path)));
                    params.put("_$script$request", request);
                    params.put("_$script$response", ret);
                    script = new TargetScript(path, request);
                    Object res = script.execution(params);
                    HttpdScriptManager.resultError(path, res);
                }
            } else {
                String fullPath = String.valueOf(this.appDirectory) + path.substring(1, path.length());
                if (!FileUtil.isFileExists((String)(String.valueOf(fullPath) + ".ms"))) {
                    String controllerPath = String.valueOf(path) + "Controller";
                    fullPath = String.valueOf(this.appDirectory) + controllerPath.substring(1, controllerPath.length());
                    if (!FileUtil.isFileExists((String)(String.valueOf(fullPath) + ".ms"))) {
                        path = String.valueOf(path) + ".mhtml";
                        fullPath = String.valueOf(this.appDirectory) + path.substring(1, path.length());
                        if (!FileUtil.isFileExists((String)fullPath)) {
                            throw new HttpdStateException(404, "\u6307\u5b9a\u30d1\u30b9[" + request.getUrlPath() + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                        }
                    } else {
                        path = String.valueOf(controllerPath) + ".ms";
                        fullPath = String.valueOf(fullPath) + ".ms";
                    }
                } else {
                    path = String.valueOf(path) + ".ms";
                    fullPath = String.valueOf(fullPath) + ".ms";
                }
                if (!FileUtil.isRead((String)fullPath)) {
                    throw new HttpdStateException(403, "\u6307\u5b9a\u30d1\u30b9[" + request.getUrlPath() + "]\u306f\u8aad\u307f\u8fbc\u307f\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093");
                }
                long time = FileUtil.getLastTime((String)fullPath);
                fullPath = null;
                TargetScript script = null;
                int type = ScriptDef.getScriptFileType(path);
                switch (type) {
                    case 1: {
                        String triggerPath = CometTriggerScript.getTriggerName(path);
                        if (triggerPath != null) {
                            ret = this.executionCometTriger(request, triggerPath, path);
                        }
                        if (ret != null) break;
                        request.setBody(null);
                        CometManager man = (CometManager)GlobalManager.getValue((String)"COMET_MANAGER");
                        man.cometRequest(request);
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), request.getKeepAliveTimeout(), request.getKeepAliveCount());
                        ret.setHttpCache(true);
                        ret.setHttpClose(false);
                        if (this.executionFilter(ret, path, request)) break;
                        if (type == 2 || type == 4 || type == 5) {
                            ret.setHttpCache(true);
                        }
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        ret.setCookieSession(request);
                        ret.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(time));
                        params.put("_$script$request", request);
                        params.put("_$script$response", ret);
                        script = new TargetScript(path, request);
                        Object res = script.execution(params);
                        HttpdScriptManager.resultError(path, res);
                        break;
                    }
                    case 31: 
                    case 32: 
                    case 98: {
                        throw new HttpdStateException(403, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306e\u5185\u5bb9\u306f\u30a2\u30af\u30bb\u30b9\u3067\u304d\u307e\u305b\u3093");
                    }
                    default: {
                        if (path.endsWith(".mhtml")) {
                            ret = HttpdResponseInstance.createResponse(request, path, request.getKeepAliveTimeout(), request.getKeepAliveCount());
                            ret.setHttpCache(true);
                            ret.setHttpClose(false);
                            if (this.executionFilter(ret, path, request)) break;
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            ret.setCookieSession(request);
                            ret.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(time));
                            params.put("_$script$request", request);
                            params.put("_$script$response", ret);
                            script = new TargetScript(path, request);
                            Object res = script.execution(params);
                            HttpdScriptManager.resultError(path, res);
                            break;
                        }
                        throw new HttpdStateException(404, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306e\u5185\u5bb9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                    }
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
    }

    public long getFileTime(String path) {
        if ((path = HttpdScriptManager.trimPath(path)) == null) {
            return -1L;
        }
        long ret = -1L;
        if (path.endsWith(".mttml")) {
            try {
                ret = TemplateScript.getTime(path);
                if (ret != -1L) {
                    return ret;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return -1L;
        }
        String fullPath = String.valueOf(this.appDirectory) + path.substring(1, path.length());
        ret = FileUtil.getLastTime((String)(String.valueOf(fullPath) + ".ms"));
        if (ret != -1L) {
            return ret;
        }
        ret = FileUtil.getLastTime((String)(String.valueOf(fullPath) + "Controller" + ".ms"));
        if (ret != -1L) {
            return ret;
        }
        ret = FileUtil.getLastTime((String)(String.valueOf(fullPath) + ".mhtml"));
        if (ret != -1L) {
            return ret;
        }
        return -1L;
    }

    public boolean isPath(String path) {
        if ((path = HttpdScriptManager.trimPath(path)) == null) {
            return false;
        }
        if (path.endsWith(".mttml")) {
            try {
                if (TemplateScript.isTemplate(path)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        String fullPath = String.valueOf(this.appDirectory) + path.substring(1, path.length());
        if (FileUtil.isFileExists((String)(String.valueOf(fullPath) + ".ms"))) {
            return true;
        }
        if (FileUtil.isFileExists((String)(String.valueOf(fullPath) + "Controller" + ".ms"))) {
            return true;
        }
        return FileUtil.isFileExists((String)(String.valueOf(fullPath) + ".mhtml"));
    }

    public boolean isRead(String path) {
        if ((path = HttpdScriptManager.trimPath(path)) == null) {
            return false;
        }
        if (path.endsWith(".mttml")) {
            try {
                if (TemplateScript.isTemplate(path)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        String fullPath = String.valueOf(this.appDirectory) + path.substring(1, path.length());
        if (FileUtil.isRead((String)(String.valueOf(fullPath) + ".ms"))) {
            return true;
        }
        if (FileUtil.isRead((String)(String.valueOf(fullPath) + "Controller" + ".ms"))) {
            return true;
        }
        return FileUtil.isRead((String)(String.valueOf(fullPath) + ".mhtml"));
    }

    private static final String trimPath(String path) {
        String lower = path.toLowerCase();
        if (path.endsWith("/")) {
            return String.valueOf(path) + "index";
        }
        if (lower.endsWith(".ms")) {
            path = path.substring(0, path.length() - ".ms".length());
        } else if (lower.endsWith(".mhtml")) {
            path = path.substring(0, path.length() - ".mhtml".length());
        }
        return path;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HttpdResponse executionCometTriger(HttpdRequest request, String trigerPath, String path) throws Exception {
        HttpdResponse ret = null;
        BaseModelImpl baseModel = new BaseModelImpl();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("... execution Trigger[" + trigerPath + "]:" + request.getQuery().getParam("groupId")));
            }
            Object res = Comet.oneSend(null, baseModel, request, trigerPath, request.getQuery().getParam("groupId"));
            if (baseModel.isCreate()) {
                try {
                    baseModel.commit();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (res != null && res instanceof String && SUCCESS_TRIGGER.equals(res)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("... exit[trigger] - comet:" + request.getQuery().getParam("groupId")));
                }
                ret = HttpdResponseInstance.createResponse(request, request.getUrlPath(), 200, request.getKeepAliveTimeout(), request.getKeepAliveCount());
                ret.setHttpCache(true);
                ret.setHttpClose(false);
                request.setBody(null);
                Comet.oneSend(ret, baseModel, request, path, request.getQuery().getParam("groupId"));
            }
            HttpdResponse httpdResponse = ret;
            return httpdResponse;
        }
        catch (Exception e) {
            throw e;
            catch (Error e2) {
                throw e2;
            }
        }
        finally {
            baseModel.clear();
        }
    }

    private final boolean executionFilter(HttpdResponse response, String path, HttpdRequest request) throws Exception {
        String filterPath = this.getExecutionFilterPath(path);
        if (filterPath == null) {
            return false;
        }
        String fullPath = FileUtil.getFullPath((String)(this.appDirectory + filterPath));
        if (FileUtil.isFileExists((String)fullPath) && FileUtil.isRead((String)fullPath)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            response.setCookieSession(request);
            response.getHeader().addHeader("Last-Modified", HttpdTimestamp.getTimestamp(FileUtil.getLastTime((String)fullPath)));
            params.put("_$script$request", request);
            params.put("_$script$response", response);
            TargetScript script = new TargetScript(filterPath, request);
            Object res = script.execution(params);
            if (response.isOutputStream() || "redirect".equals(res) || "forward".equals(res)) {
                return true;
            }
        }
        return false;
    }

    private final String getExecutionFilterPath(String path) throws Exception {
        while (true) {
            path = path.substring(0, path.length() - FileUtil.getFileName((String)path).length());
            String filterPath = path + "filter" + ".ms";
            String fullPath = FileUtil.getFullPath((String)(this.appDirectory + filterPath));
            if (FileUtil.isFileExists((String)fullPath) && FileUtil.isRead((String)fullPath)) {
                return filterPath;
            }
            if (path.length() <= 1) {
                return null;
            }
            path = path.substring(0, path.length() - 1);
        }
    }

    private static final void resultError(String path, Object res) throws Exception {
        if (res != null && res instanceof String && ((String)res).startsWith("error")) {
            String s = (String)res;
            s = s.substring("error".length());
            int state = -1;
            try {
                state = Integer.parseInt(s);
            }
            catch (Exception e) {
                state = 500;
            }
            throw new HttpdStateException(state, "\u6307\u5b9a\u30d1\u30b9[" + path + "]\u306e\u51e6\u7406\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f");
        }
    }
}

