/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import java.io.IOException;
import java.util.HashMap;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.manager.GlobalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExecutionScriptImpl
implements ExecutionScript {
    private static final String MANAGER = "_$$maachang_comet_manager";
    private static final String KEY_LOG = "log";
    private static final String ENGINE = "_$script$engine";
    private static final String CTX = "_$script$context";
    private static final Log LOG = LogFactory.getLog(ExecutionScript.class);
    private String command = null;
    private CompiledScript comp = null;
    private int scriptDataType = -1;
    private String scriptName = null;
    private HashMap<String, Object> defaultParams = null;

    private ExecutionScriptImpl() {
    }

    public ExecutionScriptImpl(String command, int scriptDataType, String name, String script) throws Exception {
        CompiledScript comp;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(command);
        if (engine == null) {
            throw new IOException("\u6307\u5b9a\u30b9\u30af\u30ea\u30d7\u30c8\u8b58\u5225\u5b50[" + command + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (!(engine instanceof Invocable)) {
            throw new IOException("\u6307\u5b9a\u30b9\u30af\u30ea\u30d7\u30c8\u8b58\u5225\u5b50[" + command + "]\u306f\u3001Invocable\u304c\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        if (!(engine instanceof Compilable)) {
            throw new IOException("\u6307\u5b9a\u30b9\u30af\u30ea\u30d7\u30c8\u8b58\u5225\u5b50[" + command + "]\u306f\u3001Compilable\u304c\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u305b\u3093");
        }
        Compilable compilable = (Compilable)((Object)engine);
        engine.put("javax.script.filename", name);
        this.comp = comp = compilable.compile(script);
        this.command = command;
        this.scriptName = name;
        this.scriptDataType = scriptDataType;
    }

    protected void finalize() throws Exception {
    }

    @Override
    public Object eval(ScriptContext ctx) throws Exception {
        if (ctx == null) {
            throw new IllegalArgumentException("ScriptContext\u304c\u672a\u8a2d\u5b9a\u3067\u3059");
        }
        return this.comp.eval(ctx);
    }

    @Override
    public Object execution(HashMap<String, Object> params) throws Exception {
        return this.execution(null, params);
    }

    @Override
    public Object execution(ScriptContext ctx, HashMap<String, Object> params) throws Exception {
        if (ctx == null) {
            ctx = new SimpleScriptContext();
        }
        Bindings bindings = ctx.getBindings(100);
        ExecutionScriptImpl.putParams(params, bindings);
        ExecutionScriptImpl.putObject(this.scriptDataType, this.command, this.scriptName, this.comp.getEngine(), this.defaultParams, ctx, bindings);
        return this.comp.eval(ctx);
    }

    @Override
    public String getCommand() {
        return this.command;
    }

    @Override
    public int getScriptDataType() {
        return this.scriptDataType;
    }

    @Override
    public String getScriptName() {
        return this.scriptName;
    }

    @Override
    public void putDefault(String key, Object value) {
        if (key == null || value == null) {
            return;
        }
        if (this.defaultParams == null) {
            this.defaultParams = new HashMap();
        }
        this.defaultParams.put(key, value);
    }

    private static final void putObject(int scriptDataType, String command, String name, ScriptEngine engine, HashMap<String, Object> defaultParams, ScriptContext ctx, Bindings bindings) {
        Object[] objs;
        bindings.put("_$current$name", (Object)name);
        bindings.put("__$detail$script", (Object)ScriptDef.getTypeByString(scriptDataType));
        bindings.put(MANAGER, (Object)GlobalManager.getInstance());
        bindings.put(KEY_LOG, (Object)LOG);
        bindings.put(CTX, (Object)ctx);
        bindings.put(ENGINE, (Object)engine);
        if (defaultParams != null && (objs = defaultParams.keySet().toArray()) != null && objs.length > 0) {
            int len = objs.length;
            int i = 0;
            while (i < len) {
                String k = (String)objs[i];
                bindings.put(k, defaultParams.get(k));
                ++i;
            }
        }
    }

    private static final void putParams(HashMap<String, Object> params, Bindings bindings) {
        int len;
        if (params != null && (len = params.size()) > 0) {
            Object[] objs = params.keySet().toArray();
            int i = 0;
            while (i < len) {
                bindings.put((String)objs[i], params.get((String)objs[i]));
                ++i;
            }
        }
    }
}

