/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.ExecutionScript;
import org.maachang.comet.httpd.engine.script.Script;
import org.maachang.comet.httpd.engine.script.SrcScript;
import org.maachang.comet.httpd.engine.script.js.JsDef;
import org.maachang.comet.httpd.engine.script.scripts.ExecutionScriptImpl;
import org.maachang.comet.httpd.engine.script.scripts.ReadScriptPlus;
import org.maachang.comet.httpd.engine.script.scripts.TemplateScriptAnalysis;
import org.maachang.comet.mdbm.SingleMDbm;
import org.maachang.dbm.MDbm;
import org.maachang.util.ConvertParam;

public class TemplateScript
implements Script {
    protected static final String MDBM_HEADER = "@mc@template:";
    protected static final String MDBM_UPDATE_HEADER = "@mc@template@update:";
    protected String path = null;
    protected byte[] baseName = null;
    protected byte[] updateName = null;
    protected long updateTime = -1L;
    private SrcScript srcScript = null;
    protected ExecutionScriptImpl executionScript = null;
    private int packageId = -1;

    private TemplateScript() {
    }

    public TemplateScript(String path) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0) {
            throw new HttpdStateException(500, "mhtml\u306e\u6307\u5b9a\u30d1\u30b9\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] baseName = TemplateScript.getBaseKey(path);
        MDbm mdbm = SingleMDbm.getInstance().getMDbm();
        if (!mdbm.containsKey(baseName)) {
            throw new HttpdStateException(500, "\u5bfe\u8c61template\u30d5\u30a1\u30a4\u30eb[" + path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        this.path = path;
        this.baseName = baseName;
        this.updateName = TemplateScript.getUpdateKey(path);
    }

    protected void clear() {
        this.updateTime = -1L;
        this.srcScript = null;
        this.executionScript = null;
    }

    public synchronized ExecutionScript getScript() throws Exception {
        MDbm mdbm = SingleMDbm.getInstance().getMDbm();
        if (!mdbm.containsKey(this.baseName)) {
            this.clear();
            throw new HttpdStateException(500, "\u5bfe\u8c61mhtml\u30d5\u30a1\u30a4\u30eb[" + this.path + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.executionScript == null || this.updateCheck() || this.packageId != JsDef.getDefaultPackageId()) {
            this.readScript();
        }
        return this.executionScript;
    }

    public synchronized String getPath() {
        return this.path;
    }

    public synchronized String getScriptName() {
        return this.path;
    }

    public int getScriptType() {
        return 10;
    }

    public synchronized SrcScript getSrcScript() {
        return this.srcScript;
    }

    public synchronized boolean isScript() {
        return this.executionScript != null;
    }

    protected void readScript() throws Exception {
        MDbm mdbm = SingleMDbm.getInstance().getMDbm();
        byte[] b = mdbm.get(this.baseName);
        if (b == null) {
            this.clear();
            return;
        }
        String script = new String(b, "UTF8");
        b = null;
        script = TemplateScriptAnalysis.analysis(script);
        StringBuilder buf = new StringBuilder();
        this.packageId = JsDef.pushDefaultPackage(buf);
        ReadScriptPlus.addMHTML(buf, script, this.path);
        script = buf.toString();
        buf = null;
        script = ReadScriptPlus.convert(false, script);
        this.srcScript = new SrcScript(script);
        this.executionScript = new ExecutionScriptImpl("js", this.getScriptType(), this.getPath(), script);
        script = null;
        this.updateTime = this.getUpdate();
    }

    private boolean updateCheck() throws Exception {
        long tm = this.getUpdate();
        return tm != this.updateTime;
    }

    private long getUpdate() throws Exception {
        MDbm mdbm = SingleMDbm.getInstance().getMDbm();
        byte[] b = mdbm.get(this.updateName);
        if (b == null || b.length != 8) {
            throw new IllegalArgumentException("\u66f4\u65b0\u78ba\u8a8d\u30c7\u30fc\u30bf\u306f\u4e0d\u6b63\u3067\u3059");
        }
        return ConvertParam.convertLong((int)0, (byte[])b);
    }

    public static final boolean isTemplate(String path) throws Exception {
        MDbm mdbm = SingleMDbm.getInstance().getMDbm();
        return mdbm.containsKey(TemplateScript.getBaseKey(path));
    }

    public static final long getTime(String path) throws Exception {
        MDbm mdbm = SingleMDbm.getInstance().getMDbm();
        byte[] b = mdbm.get(TemplateScript.getUpdateKey(path));
        if (b == null || b.length != 8) {
            return -1L;
        }
        return ConvertParam.convertLong((int)0, (byte[])b);
    }

    public static final byte[] getBaseKey(String key) throws Exception {
        return (MDBM_HEADER + key).getBytes("UTF8");
    }

    public static final byte[] getUpdateKey(String key) throws Exception {
        return (MDBM_UPDATE_HEADER + key).getBytes("UTF8");
    }
}

