/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.comet.httpd.engine.script.service.mail;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.comet.httpd.engine.script.service.mail.MailAuth;
import org.maachang.comet.httpd.engine.script.service.mail.ReceiveMail;
import org.maachang.comet.httpd.engine.script.service.mail.ResultAttached;
import org.maachang.comet.httpd.engine.script.service.mail.ResultMail;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReceiveMailService {
    private static final Log LOG = LogFactory.getLog(ReceiveMailService.class);
    private static final String UNKNOWN_ATTACHMENT = "attachment-";

    public static ArrayList<ResultMail> receiveMailTo(boolean mode, ReceiveMail receiveMail) {
        ArrayList<ResultMail> ret = null;
        try {
            ret = ReceiveMailService.receiveMail(mode, receiveMail);
        }
        catch (Exception e) {
            LOG.error((Object)"receiveMailError", (Throwable)e);
            ret = null;
        }
        return ret;
    }

    public static ArrayList<ResultMail> receiveMail(boolean mode, ReceiveMail receiveMail) throws Exception {
        if (receiveMail == null || !receiveMail.check()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        Properties props = new Properties();
        props.setProperty("mail.pop3.host", receiveMail.getHost());
        if (receiveMail.getPort() > 0) {
            props.setProperty("mail.pop3.port", String.valueOf(receiveMail.getPort()));
        }
        if (receiveMail.getTimeout() > 0L) {
            props.setProperty("mail.pop3.connectiontimeout", String.valueOf(receiveMail.getTimeout()));
            props.setProperty("mail.pop3.timeout", String.valueOf(receiveMail.getTimeout()));
        }
        if (receiveMail.isSsl()) {
            props.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.pop3.socketFactory.fallback", "false");
            if (receiveMail.getPort() > 0) {
                props.setProperty("mail.pop3.socketFactory.port", String.valueOf(receiveMail.getPort()));
            }
        }
        Session session = Session.getInstance((Properties)props, (Authenticator)new MailAuth(receiveMail.getUser(), receiveMail.getPasswd()));
        Store store = null;
        Folder folder = null;
        try {
            store = session.getStore("pop3");
            store.connect();
            folder = store.getFolder("INBOX");
            folder.open(1);
            Message[] messages = folder.getMessages();
            if (messages != null && messages.length > 0) {
                int len = messages.length;
                ArrayList<ResultMail> ret = new ArrayList<ResultMail>();
                int cnt = 0;
                int i = 0;
                while (i < len) {
                    if (cnt > 0 && mode) break;
                    ResultMail res = new ResultMail();
                    ReceiveMailService.oneResult(res, 1, (Part)messages[i]);
                    if (res != null) {
                        ret.add(res);
                        ++cnt;
                    }
                    messages[i].setFlag(Flags.Flag.DELETED, receiveMail.isDelete());
                    ++i;
                }
                ArrayList<ResultMail> arrayList = ret;
                return arrayList;
            }
            ArrayList<ResultMail> arrayList = new ArrayList<ResultMail>();
            return arrayList;
        }
        finally {
            try {
                folder.close(false);
            }
            catch (Exception exception) {}
            try {
                store.close();
            }
            catch (Exception exception) {}
        }
    }

    private static int oneResult(ResultMail out, int attCnt, Part part) throws Exception {
        String disp;
        String plus = "";
        boolean attachment = false;
        if (part instanceof Message) {
            ReceiveMailService.setMessage(out, (Message)part);
        }
        if (part.isMimeType("text/plain")) {
            if (out.getBody() != null) {
                out.setBody(String.valueOf(out.getBody()) + (String)part.getContent());
            } else {
                out.setBody((String)part.getContent());
            }
        } else if (part.isMimeType("multipart/*")) {
            Multipart multi = (Multipart)part.getContent();
            int len = multi.getCount();
            int i = 0;
            while (i < len) {
                attCnt = ReceiveMailService.oneResult(out, attCnt, (Part)multi.getBodyPart(i));
                ++i;
            }
        } else if (part.isMimeType("message/rfc822")) {
            attCnt = ReceiveMailService.oneResult(out, attCnt, (Part)part.getContent());
        } else if (part.isMimeType("text/html")) {
            plus = ".html";
            attachment = true;
        } else {
            attachment = true;
        }
        if (attachment && ((disp = part.getDisposition()) == null || disp.equalsIgnoreCase("attachment"))) {
            String fileName = part.getFileName();
            fileName = fileName != null || (fileName = fileName.trim()).length() <= 0 ? MimeUtility.decodeText((String)fileName) : UNKNOWN_ATTACHMENT + ++attCnt + plus;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            InputStream in = part.getInputStream();
            byte[] bin = new byte[8192];
            while (true) {
                int len;
                if ((len = in.read(bin)) <= 0) {
                    if (len > -1) continue;
                    break;
                }
                buf.write(bin, 0, len);
            }
            bin = null;
            buf.flush();
            byte[] att = buf.toByteArray();
            buf.close();
            in.close();
            ArrayList<ResultAttached> lst = null;
            lst = out.getAttached();
            if (lst == null) {
                lst = new ArrayList();
                out.setAttached(lst);
            }
            ResultAttached ra = new ResultAttached();
            ra.setAttached(att);
            ra.setFileName(fileName);
            lst.add(ra);
        }
        return attCnt;
    }

    private static void setMessage(ResultMail res, Message message) throws Exception {
        InternetAddress internetAddr;
        int i;
        int len;
        res.setDate(message.getSentDate());
        res.setSubject(message.getSubject());
        Address[] addr = null;
        addr = message.getFrom();
        if (addr != null) {
            len = addr.length;
            ArrayList<String> froms = new ArrayList<String>();
            i = 0;
            while (i < len) {
                internetAddr = (InternetAddress)addr[i];
                froms.add(internetAddr.getAddress());
                ++i;
            }
            res.setFrom(froms);
        }
        if ((addr = message.getRecipients(Message.RecipientType.TO)) != null) {
            len = addr.length;
            ArrayList<String> tos = new ArrayList<String>();
            i = 0;
            while (i < len) {
                internetAddr = (InternetAddress)addr[i];
                tos.add(internetAddr.getAddress());
                ++i;
            }
            res.setTo(tos);
        }
    }
}

